/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.core.engine;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.php.internal.core.util.XMLWriter;
import org.eclipse.php.internal.debug.core.zend.debugger.CodeCoverageData;
import org.eclipse.php.profile.core.PHPProfileCorePlugin;
import org.eclipse.php.profile.core.data.ProfilerCallTrace;
import org.eclipse.php.profile.core.data.ProfilerCallTraceLayer;
import org.eclipse.php.profile.core.data.ProfilerData;
import org.eclipse.php.profile.core.data.ProfilerFileData;
import org.eclipse.php.profile.core.data.ProfilerFunctionData;
import org.eclipse.php.profile.core.data.ProfilerGlobalData;
import org.eclipse.php.profile.core.engine.DefaultProfilerDB;
import org.eclipse.php.profile.core.engine.ProfilerDB;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProfilerDataSerializationUtil {
    private XMLWriter fXML;

    private ProfilerDataSerializationUtil(XMLWriter xml) {
        this.fXML = xml;
    }

    private ProfilerDataSerializationUtil() {
    }

    private static String pack(byte[] arr) {
        StringBuilder buf = new StringBuilder();
        buf.append(arr.length).append(":");
        int i = 0;
        while (i < arr.length) {
            buf.append(arr[i]);
            if (i < arr.length - 1) {
                buf.append(",");
            }
            ++i;
        }
        return buf.toString();
    }

    private static byte[] unpackByte(String buf) {
        byte[] arr = null;
        int idx = buf.indexOf(58);
        if (idx != -1) {
            int arr_len = Integer.parseInt(buf.substring(0, idx));
            String[] bytes = buf.substring(idx + 1).split(",");
            if (bytes.length == arr_len) {
                arr = new byte[arr_len];
                int i = 0;
                while (i < arr_len) {
                    arr[i] = Byte.parseByte(bytes[i]);
                    ++i;
                }
            }
        }
        return arr;
    }

    public static void serialize(ProfilerDB[] profilerDBs, OutputStream out) {
        XMLWriter xml = null;
        try {
            try {
                xml = new XMLWriter(out);
                ProfilerDataSerializationUtil su = new ProfilerDataSerializationUtil(xml);
                xml.startTag("profilerDB", null);
                int i = 0;
                while (i < profilerDBs.length) {
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("date", Long.toString(profilerDBs[i].getProfileDate().getTime()));
                    xml.startTag("profileSession", parameters);
                    su.serialize(profilerDBs[i].getProfilerData());
                    xml.endTag("profileSession");
                    ++i;
                }
                xml.endTag("profilerDB");
            }
            catch (UnsupportedEncodingException e) {
                PHPProfileCorePlugin.log(e);
                if (xml != null) {
                    xml.flush();
                    xml.close();
                }
            }
        }
        finally {
            if (xml != null) {
                xml.flush();
                xml.close();
            }
        }
    }

    private void serialize(ProfilerData data) {
        if (data == null) {
            return;
        }
        this.serialize(data.getGlobalData());
        this.serialize(data.getCallTrace());
        ProfilerFileData[] fileData = data.getFiles();
        int i = 0;
        while (i < fileData.length) {
            this.serialize(fileData[i]);
            ++i;
        }
    }

    private void serialize(ProfilerCallTrace callTrace) {
        if (callTrace == null) {
            return;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("layers", Integer.toString(callTrace.getLayersCount()));
        this.fXML.startTag("callTrace", parameters);
        ProfilerCallTraceLayer[] layers = callTrace.getLayers();
        int i = 0;
        while (i < layers.length) {
            this.serialize(layers[i]);
            ++i;
        }
        this.fXML.endTag("callTrace");
    }

    private void serialize(ProfilerCallTraceLayer layer) {
        if (layer == null) {
            return;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("type", Integer.toString(layer.getType()));
        parameters.put("line", Integer.toString(layer.getLineNumber()));
        parameters.put("id", Integer.toString(layer.getCalledID()));
        parameters.put("timestampS", Integer.toString(layer.getTimestampSeconds()));
        parameters.put("timestampM", Integer.toString(layer.getTimestampMicroseconds()));
        parameters.put("durationS", Integer.toString(layer.getDurationSeconds()));
        parameters.put("durationM", Integer.toString(layer.getDurationMicroeconds()));
        this.fXML.startTag("callTraceLayer", parameters);
        this.fXML.endTag("callTraceLayer");
    }

    private void serialize(ProfilerGlobalData data) {
        if (data == null) {
            return;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("uri", data.getURI());
        parameters.put("originalURL", data.getOriginalURL());
        parameters.put("query", data.getQuery());
        parameters.put("options", data.getOptions());
        parameters.put("path", data.getPath());
        parameters.put("timeS", Integer.toString(data.getTimeSeconds()));
        parameters.put("timeM", Integer.toString(data.getTimeMicroSeconds()));
        parameters.put("dataSize", Integer.toString(data.getDataSize()));
        parameters.put("files", Integer.toString(data.getFileCount()));
        this.fXML.startTag("globalData", parameters);
        String[] fileNames = data.getFileNames();
        int i = 0;
        while (i < fileNames.length) {
            this.fXML.printSimpleTag("file", (Object)fileNames[i]);
            ++i;
        }
        this.fXML.endTag("globalData");
    }

    private void serialize(ProfilerFileData data) {
        if (data == null) {
            return;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("name", data.getName());
        parameters.put("local", data.getLocalName());
        parameters.put("functions", Integer.toString(data.getFunctionsCount()));
        parameters.put("time", Double.toString(data.getTotalOwnTime()));
        this.fXML.startTag("fileData", parameters);
        ProfilerFunctionData[] functionData = data.getFunctions();
        int i = 0;
        while (i < functionData.length) {
            this.serialize(functionData[i]);
            ++i;
        }
        this.serialize(data.getCodeCoverageData());
        this.fXML.endTag("fileData");
    }

    private void serialize(ProfilerFunctionData data) {
        if (data == null) {
            return;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("file", data.getAbsoluteFileName());
        parameters.put("localFile", data.getLocalFileName());
        parameters.put("name", data.toString());
        parameters.put("line", Integer.toString(data.getLineNumber()));
        parameters.put("id", Integer.toString(data.getID()));
        parameters.put("ownS", Integer.toString(data.getOwnTimeSeconds()));
        parameters.put("ownM", Integer.toString(data.getOwnTimeMicroseconds()));
        parameters.put("totalS", Integer.toString(data.getTotalTimeSeconds()));
        parameters.put("totalM", Integer.toString(data.getTotalTimeMicroseconds()));
        parameters.put("calls", Integer.toString(data.getCallsCount()));
        this.fXML.startTag("functionData", parameters);
        this.fXML.endTag("functionData");
    }

    private void serialize(CodeCoverageData data) {
        if (data == null) {
            return;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("file", data.getFileName());
        parameters.put("localFile", data.getLocalFileName());
        parameters.put("linesNum", Integer.toString(data.getLinesNum()));
        parameters.put("phpLinesNum", Integer.toString(data.getPHPLinesNum()));
        parameters.put("coverageBitmask", ProfilerDataSerializationUtil.pack(data.getCoverageBitmask()));
        parameters.put("significanceBitmask", ProfilerDataSerializationUtil.pack(data.getSignificanceBitmask()));
        this.fXML.startTag("coverageData", parameters);
        this.fXML.endTag("coverageData");
    }

    public static ProfilerDB[] deserialize(InputStream in) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(in);
            ArrayList<DefaultProfilerDB> profilerDBs = new ArrayList<DefaultProfilerDB>();
            NodeList l = doc.getElementsByTagName("profileSession");
            int i = 0;
            while (l.item(i) != null) {
                if (l.item(i).getNodeType() == 1) {
                    Element e = (Element)l.item(i);
                    Date profileDate = new Date(Long.parseLong(e.getAttribute("date")));
                    ProfilerDataSerializationUtil su = new ProfilerDataSerializationUtil();
                    DefaultProfilerDB db = new DefaultProfilerDB(su.deserializeProfilerData(e), profileDate);
                    profilerDBs.add(db);
                }
                ++i;
            }
            return profilerDBs.toArray(new ProfilerDB[profilerDBs.size()]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ProfilerData deserializeProfilerData(Element rootElement) {
        Element e = (Element)rootElement.getElementsByTagName("globalData").item(0);
        ProfilerGlobalData globalData = this.deserializeGlobalData(e);
        e = (Element)rootElement.getElementsByTagName("callTrace").item(0);
        ProfilerCallTrace callTrace = this.deserializeCallTrace(e);
        ArrayList<ProfilerFileData> fileData = new ArrayList<ProfilerFileData>();
        NodeList l = rootElement.getElementsByTagName("fileData");
        int i = 0;
        while (l.item(i) != null) {
            fileData.add(this.deserializeFileData((Element)l.item(i), globalData));
            ++i;
        }
        return new ProfilerData(globalData, fileData, callTrace);
    }

    private ProfilerFileData deserializeFileData(Element rootElement, ProfilerGlobalData globalData) {
        String fileName = rootElement.getAttribute("name");
        String localFileName = rootElement.getAttribute("local");
        int functionsNum = Integer.parseInt(rootElement.getAttribute("functions"));
        double totalOwnTime = Double.parseDouble(rootElement.getAttribute("time"));
        ArrayList<ProfilerFunctionData> functionData = new ArrayList<ProfilerFunctionData>();
        NodeList l = rootElement.getElementsByTagName("functionData");
        int i = 0;
        while (l.item(i) != null) {
            functionData.add(this.deserializeFunctionData((Element)l.item(i)));
            ++i;
        }
        Element e = (Element)rootElement.getElementsByTagName("coverageData").item(0);
        CodeCoverageData codeCoverage = this.deserializeCoverageData(e, globalData);
        ProfilerFileData data = new ProfilerFileData(fileName, localFileName, functionsNum, totalOwnTime, functionData);
        data.setCodeCoverageData(codeCoverage);
        return data;
    }

    private ProfilerFunctionData deserializeFunctionData(Element rootElement) {
        String fileName = rootElement.getAttribute("file");
        String localFileName = rootElement.getAttribute("localFile");
        String functionName = rootElement.getAttribute("name");
        int lineNumber = Integer.parseInt(rootElement.getAttribute("line"));
        int id = Integer.parseInt(rootElement.getAttribute("id"));
        int ownTimeSeconds = Integer.parseInt(rootElement.getAttribute("ownS"));
        int ownTimeMicroSeconds = Integer.parseInt(rootElement.getAttribute("ownM"));
        int totalTimeSeconds = Integer.parseInt(rootElement.getAttribute("totalS"));
        int totalTimeMicroSeconds = Integer.parseInt(rootElement.getAttribute("totalM"));
        int callsCount = Integer.parseInt(rootElement.getAttribute("calls"));
        ProfilerFunctionData functionData = new ProfilerFunctionData(fileName, functionName, lineNumber, id, ownTimeSeconds, ownTimeMicroSeconds, totalTimeSeconds, totalTimeMicroSeconds, callsCount);
        functionData.setLocalFileName(localFileName);
        return functionData;
    }

    private ProfilerCallTrace deserializeCallTrace(Element rootElement) {
        int layersNum = Integer.parseInt(rootElement.getAttribute("layers"));
        NodeList l = rootElement.getElementsByTagName("callTraceLayer");
        ArrayList<ProfilerCallTraceLayer> layers = new ArrayList<ProfilerCallTraceLayer>();
        int i = 0;
        while (l.item(i) != null) {
            layers.add(this.deserializeCallTraceLayer((Element)l.item(i)));
            ++i;
        }
        ProfilerCallTrace callTrace = new ProfilerCallTrace(layers);
        callTrace.setLayersCount(layersNum);
        return callTrace;
    }

    private ProfilerCallTraceLayer deserializeCallTraceLayer(Element rootElement) {
        int type = Integer.parseInt(rootElement.getAttribute("type"));
        int lineNumber = Integer.parseInt(rootElement.getAttribute("line"));
        int id = Integer.parseInt(rootElement.getAttribute("id"));
        int timestampSeconds = Integer.parseInt(rootElement.getAttribute("timestampS"));
        int timestampMicroSeconds = Integer.parseInt(rootElement.getAttribute("timestampM"));
        int durationSeconds = Integer.parseInt(rootElement.getAttribute("durationS"));
        int durationMicroSeconds = Integer.parseInt(rootElement.getAttribute("durationM"));
        return new ProfilerCallTraceLayer(type, lineNumber, id, timestampSeconds, timestampMicroSeconds, durationSeconds, durationMicroSeconds);
    }

    private ProfilerGlobalData deserializeGlobalData(Element rootElement) {
        String uri = rootElement.getAttribute("uri");
        String originalURL = rootElement.getAttribute("originalURL");
        String query = rootElement.getAttribute("query");
        String options = rootElement.getAttribute("options");
        String path = rootElement.getAttribute("path");
        int timeSeconds = Integer.parseInt(rootElement.getAttribute("timeS"));
        int timeMicroseconds = Integer.parseInt(rootElement.getAttribute("timeM"));
        int dataSize = Integer.parseInt(rootElement.getAttribute("dataSize"));
        int filesNumber = Integer.parseInt(rootElement.getAttribute("files"));
        ArrayList<String> files = new ArrayList<String>();
        NodeList l = rootElement.getElementsByTagName("file");
        int i = 0;
        while (l.item(i) != null) {
            files.add(l.item(i).getFirstChild().getNodeValue());
            ++i;
        }
        return new ProfilerGlobalData(uri, originalURL, query, options, path, timeSeconds, timeMicroseconds, dataSize, filesNumber, files);
    }

    private CodeCoverageData deserializeCoverageData(Element rootElement, ProfilerGlobalData globalData) {
        if (rootElement == null) {
            return null;
        }
        String fileName = rootElement.getAttribute("file");
        String localFileName = rootElement.getAttribute("localFile");
        int linesNum = Integer.parseInt(rootElement.getAttribute("linesNum"));
        int phpLinesNum = Integer.parseInt(rootElement.getAttribute("phpLinesNum"));
        byte[] coverageBitmask = ProfilerDataSerializationUtil.unpackByte(rootElement.getAttribute("coverageBitmask"));
        byte[] significanceBitmask = ProfilerDataSerializationUtil.unpackByte(rootElement.getAttribute("significanceBitmask"));
        CodeCoverageData data = new CodeCoverageData(fileName, linesNum, coverageBitmask);
        data.setURL(globalData.getOriginalURL());
        data.setLocalFileName(localFileName);
        data.setPHPLinesNum(phpLinesNum);
        data.setSignificanceBitmask(significanceBitmask);
        return data;
    }
}

