/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.gef.header.edit;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.editor.constants.CoreImages;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.swing.MigLayout.gef.GefMessages;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.actions.DimensionHeaderAction;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.actions.SetAlignmentRowAction;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.actions.SetGrowAction;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.actions.SetSizeAction;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.edit.DimensionHeaderEditPart;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigRowInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.ui.RowEditDialog;

public class RowHeaderEditPart
extends DimensionHeaderEditPart<MigRowInfo> {
    private static final String PREF_TITLE = "[pref!]";
    private static final String PREF_CODE = "pref!";
    private final MigRowInfo m_row;

    public RowHeaderEditPart(MigLayoutInfo layout, MigRowInfo row, Figure containerFigure) {
        super(layout, row, containerFigure);
        this.m_row = row;
    }

    protected Figure createFigure() {
        Figure newFigure = new Figure(){

            protected void paintClientArea(Graphics graphics) {
                Rectangle r = this.getClientArea();
                graphics.setForegroundColor(ColorConstants.buttonDarker);
                graphics.drawLine(r.x, r.y, r.right(), r.y);
                graphics.drawLine(r.x, r.bottom() - 1, r.right(), r.bottom() - 1);
                int index = RowHeaderEditPart.this.getIndex();
                String title = Integer.toString(index);
                Dimension textExtents = TextUtilities.INSTANCE.getTextExtents(title, graphics.getFont());
                if (r.height < textExtents.height) {
                    return;
                }
                int titleTop = r.y + (r.height - textExtents.height) / 2;
                int titleBottom = titleTop + textExtents.height;
                int x = r.x + (r.width - textExtents.width) / 2;
                graphics.setForegroundColor(ColorConstants.black);
                graphics.drawText(title, x, titleTop);
                if (titleTop - r.y > 13) {
                    Image image = RowHeaderEditPart.this.m_row.getAlignment(true).getSmallImageDescriptor().createImage();
                    int y = r.y + 2;
                    this.drawCentered(graphics, image, y);
                    image.dispose();
                }
                if (((MigRowInfo)RowHeaderEditPart.this.m_dimension).hasGrow() && titleBottom + 3 + 7 + 3 < r.bottom()) {
                    ImageDescriptor descriptor = CoreImages.ALIGNMENT_V_SMALL_GROW;
                    Image image = (Image)RowHeaderEditPart.this.getViewer().getResourceManager().get((DeviceResourceDescriptor)descriptor);
                    this.drawCentered(graphics, image, r.bottom() - 3 - image.getBounds().height);
                }
            }

            private void drawCentered(Graphics graphics, Image image, int y) {
                int x = (this.getBounds().width - image.getBounds().width) / 2;
                graphics.drawImage(image, x, y);
            }
        };
        newFigure.setFont(DEFAULT_FONT);
        newFigure.setOpaque(true);
        return newFigure;
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        Figure figure = this.getFigure();
        int index = this.getIndex();
        Interval interval = this.m_layout.getGridInfo().getRowIntervals()[index];
        Rectangle bounds = new Rectangle(0, interval.begin(), ((GraphicalEditPart)this.getParent()).getFigure().getSize().width, interval.length() + 1);
        bounds.performTranslate(0, this.getOffset().y);
        figure.setBounds(bounds);
        figure.setToolTipText(this.m_row.getTooltip());
    }

    @Override
    public int getIndex() {
        return this.m_layout.getRows().indexOf(this.m_row);
    }

    public void buildContextMenu(IMenuManager manager) {
        if (!this.m_layout.canChangeDimensions()) {
            return;
        }
        manager.add((IAction)new DimensionHeaderAction<MigRowInfo>((DimensionHeaderEditPart)this, GefMessages.RowHeaderEditPart_insertRow){

            @Override
            protected void run(MigRowInfo dimension, int index) throws Exception {
                RowHeaderEditPart.this.m_layout.insertRow(index);
            }
        });
        manager.add((IAction)new DimensionHeaderAction<MigRowInfo>((DimensionHeaderEditPart)this, GefMessages.RowHeaderEditPart_appendRow){

            @Override
            protected void run(MigRowInfo dimension, int index) throws Exception {
                RowHeaderEditPart.this.m_layout.insertRow(index + 1);
            }
        });
        manager.add((IAction)new DimensionHeaderAction<MigRowInfo>((DimensionHeaderEditPart)this, GefMessages.RowHeaderEditPart_deleteRow){

            @Override
            protected void run(MigRowInfo dimension, int index) throws Exception {
                RowHeaderEditPart.this.m_layout.deleteRow(index);
            }
        });
        manager.add((IAction)new DimensionHeaderAction<MigRowInfo>((DimensionHeaderEditPart)this, GefMessages.RowHeaderEditPart_clearRow){

            @Override
            protected void run(MigRowInfo dimension, int index) throws Exception {
                RowHeaderEditPart.this.m_layout.clearRow(index);
            }
        });
        manager.add((IAction)new DimensionHeaderAction<MigRowInfo>((DimensionHeaderEditPart)this, GefMessages.RowHeaderEditPart_splitRow){

            @Override
            protected void run(MigRowInfo dimension, int index) throws Exception {
                RowHeaderEditPart.this.m_layout.splitRow(index);
            }
        });
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new SetAlignmentRowAction(this, MigRowInfo.Alignment.DEFAULT));
        manager.add((IAction)new SetAlignmentRowAction(this, MigRowInfo.Alignment.TOP));
        manager.add((IAction)new SetAlignmentRowAction(this, MigRowInfo.Alignment.CENTER));
        manager.add((IAction)new SetAlignmentRowAction(this, MigRowInfo.Alignment.BOTTOM));
        manager.add((IAction)new SetAlignmentRowAction(this, MigRowInfo.Alignment.FILL));
        manager.add((IAction)new SetAlignmentRowAction(this, MigRowInfo.Alignment.BASELINE));
        manager.add((IContributionItem)new Separator());
        manager.add(new SetGrowAction<MigRowInfo>(this, GefMessages.RowHeaderEditPart_grow, CoreImages.ALIGNMENT_V_MENU_GROW));
        manager.add((IContributionItem)new Separator());
        manager.add(new SetSizeAction<MigRowInfo>((DimensionHeaderEditPart<MigRowInfo>)this, GefMessages.RowHeaderEditPart_defaultSize, null));
        manager.add(new SetSizeAction<MigRowInfo>(this, PREF_TITLE, PREF_CODE));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new Action(GefMessages.RowHeaderEditPart_properties){

            public void run() {
                RowHeaderEditPart.this.editDimension();
            }
        });
    }

    @Override
    protected void editDimension() {
        new RowEditDialog(DesignerPlugin.getShell(), this.m_layout, this.m_row).open();
    }
}

