/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.widgets.menu;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.AssociationObject;
import org.eclipse.wb.core.model.association.AssociationObjects;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.menu.AbstractMenuObject;
import org.eclipse.wb.internal.core.model.menu.IMenuInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuItemInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuPolicy;
import org.eclipse.wb.internal.core.model.menu.MenuObjectInfoUtils;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swt.model.widgets.ItemInfo;
import org.eclipse.wb.internal.swt.model.widgets.live.SwtLiveManager;
import org.eclipse.wb.internal.swt.model.widgets.live.menu.MenuItemLiveManager;
import org.eclipse.wb.internal.swt.model.widgets.menu.MenuInfo;
import org.eclipse.wb.internal.swt.model.widgets.menu.MenuItemStylePresentation;
import org.eclipse.wb.internal.swt.support.MenuSupport;

public final class MenuItemInfo
extends ItemInfo
implements IAdaptable {
    private final MenuItemInfo m_this = this;
    private final IObjectPresentation m_presentation = new MenuItemStylePresentation(this);
    private final JavaEventListener m_stylePropertyListener = new JavaEventListener(){

        public void setPropertyExpression(GenericPropertyImpl property, String[] source, Object[] value, boolean[] shouldSet) throws Exception {
            if (property.getJavaInfo() == MenuItemInfo.this.m_this && "Style".equals(property.getTitle())) {
                boolean becomesSeparator;
                boolean wasCascade = ((Integer)property.getValue() & 0x40) != 0;
                boolean wasSeparator = ((Integer)property.getValue() & 2) != 0;
                String src = source[0];
                final boolean becomesCascade = src != null && src.indexOf("SWT.CASCADE") != -1;
                boolean bl = becomesSeparator = src != null && src.indexOf("SWT.SEPARATOR") != -1;
                if (wasCascade == becomesCascade && wasSeparator == becomesSeparator) {
                    return;
                }
                ExecutionUtils.run((ObjectInfo)MenuItemInfo.this.m_this, (RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        if (becomesCascade) {
                            MenuItemInfo.this.addSubMenu();
                        } else {
                            MenuItemInfo.this.deleteSubMenu();
                        }
                        if (becomesSeparator) {
                            MenuItemInfo.this.getPropertyByTitle("text").setValue(Property.UNKNOWN_VALUE);
                        }
                    }
                });
            }
        }

        public void addBefore(JavaInfo parent, JavaInfo child) throws Exception {
            if (parent == MenuItemInfo.this.m_this && child instanceof MenuInfo) {
                this.setStyleSource("org.eclipse.swt.SWT.CASCADE");
            }
        }

        public void moveBefore(JavaInfo child, ObjectInfo oldParent, JavaInfo newParent) throws Exception {
            if (oldParent == MenuItemInfo.this.m_this && child instanceof MenuInfo) {
                this.setStyleSource("org.eclipse.swt.SWT.NONE");
            }
            if (newParent == MenuItemInfo.this.m_this && child instanceof MenuInfo) {
                this.setStyleSource("org.eclipse.swt.SWT.CASCADE");
            }
        }

        private void setStyleSource(String source) throws Exception {
            MenuItemInfo.this.removeBroadcastListener((Object)this);
            try {
                GenericProperty styleProperty = (GenericProperty)MenuItemInfo.this.getPropertyByTitle("Style");
                styleProperty.setExpression(source, Property.UNKNOWN_VALUE);
            }
            finally {
                MenuItemInfo.this.addBroadcastListener((Object)this);
            }
        }
    };
    private final IMenuItemInfo m_itemImpl = new MenuItemImpl();

    public MenuItemInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
        this.addBroadcastListeners();
    }

    private void addBroadcastListeners() {
        this.addBroadcastListener(this.m_stylePropertyListener);
        this.addBroadcastListener(new JavaEventListener(){

            public void addAfter(JavaInfo parent, JavaInfo child) throws Exception {
                if (child == MenuItemInfo.this.m_this) {
                    if (JavaInfoUtils.hasTrueParameter((JavaInfo)MenuItemInfo.this.m_this, (String)"MenuItem.createCascadeMenu")) {
                        MenuItemInfo.this.addSubMenu();
                    }
                    MenuItemInfo.this.removeBroadcastListener((Object)this);
                }
            }
        });
        this.addBroadcastListener(new JavaEventListener(){

            public void clipboardCopy(JavaInfo javaInfo, List<ClipboardCommand> commands) throws Exception {
                if (javaInfo == MenuItemInfo.this.m_this && MenuItemInfo.this.hasSubMenu()) {
                    MenuInfo menuInfo = (MenuInfo)((Object)MenuItemInfo.this.getChildren(MenuInfo.class).get(0));
                    final JavaInfoMemento menuMemento = JavaInfoMemento.createMemento((JavaInfo)menuInfo);
                    commands.add(new ClipboardCommand(){
                        private static final long serialVersionUID = 0L;

                        public void execute(JavaInfo javaInfo) throws Exception {
                            MenuInfo menu = (MenuInfo)menuMemento.create(javaInfo);
                            menu.command_CREATE((MenuItemInfo)javaInfo);
                            menuMemento.apply();
                        }
                    });
                }
            }
        });
    }

    public MenuInfo getSubMenu() {
        List subMenus = this.getChildren(MenuInfo.class);
        Assert.isLegal((subMenus.size() <= 1 ? 1 : 0) != 0);
        return !subMenus.isEmpty() ? (MenuInfo)((Object)subMenus.get(0)) : null;
    }

    private boolean hasSubMenu() {
        return !this.getChildren(MenuInfo.class).isEmpty();
    }

    private void addSubMenu() throws Exception {
        if (!this.hasSubMenu()) {
            JavaInfo menu = JavaInfoUtils.createJavaInfo((AstEditor)this.getEditor(), MenuSupport.getMenuClass(), (CreationSupport)new ConstructorCreationSupport());
            AssociationObject association = AssociationObjects.invocationChild((String)"%parent%.setMenu(%child%)", (boolean)true);
            JavaInfoUtils.add((JavaInfo)menu, (AssociationObject)association, (JavaInfo)this, null);
        }
    }

    private void deleteSubMenu() throws Exception {
        if (this.hasSubMenu()) {
            ((MenuInfo)((Object)this.getChildren(MenuInfo.class).get(0))).delete();
        }
    }

    public IObjectPresentation getPresentation() {
        return this.m_presentation;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(IMenuItemInfo.class)) {
            return adapter.cast(this.m_itemImpl);
        }
        return null;
    }

    @Override
    protected SwtLiveManager getLiveComponentsManager() {
        return new MenuItemLiveManager(this);
    }

    private final class MenuItemImpl
    extends AbstractMenuObject
    implements IMenuItemInfo,
    IMenuPolicy {
        public MenuItemImpl() {
            super((ObjectInfo)MenuItemInfo.this.m_this);
        }

        public Object getModel() {
            return MenuItemInfo.this.m_this;
        }

        public ImageDescriptor getImageDescriptor() {
            return Optional.ofNullable(MenuItemInfo.this.m_this.getImage()).map(ImageDescriptor::createFromImage).orElse(null);
        }

        public Rectangle getBounds() {
            return MenuItemInfo.this.m_this.getBounds();
        }

        public IMenuInfo getMenu() {
            MenuInfo subMenu = MenuItemInfo.this.getSubMenu();
            return MenuObjectInfoUtils.getMenuInfo((Object)((Object)subMenu));
        }

        public IMenuPolicy getPolicy() {
            return this;
        }

        public boolean validateCreate(Object object) {
            return false;
        }

        public boolean validatePaste(Object mementoObject) {
            return false;
        }

        public boolean validateMove(Object object) {
            if (object instanceof MenuInfo) {
                MenuInfo menuInfo = (MenuInfo)((Object)object);
                return !menuInfo.isParentOf((ObjectInfo)MenuItemInfo.this.m_this);
            }
            return false;
        }

        public void commandCreate(Object object, Object nextObject) throws Exception {
        }

        public List<?> commandPaste(Object mementoObject, Object nextObject) throws Exception {
            return Collections.emptyList();
        }

        public void commandMove(Object object, Object nextObject) throws Exception {
            MenuInfo menuInfo = (MenuInfo)((Object)object);
            menuInfo.command_ADD(MenuItemInfo.this.m_this);
            MenuObjectInfoUtils.setSelectingObject((Object)((Object)menuInfo));
        }
    }
}

