/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakpoint;
import org.eclipse.cdt.utils.Addr64;

public class MIBreakpointDMData
implements IBreakpoints.IBreakpointDMData {
    public static final String DSFMIBREAKPOINT = "org.eclipse.cdt.dsf.debug.breakpoint.mi";
    public static final String NUMBER = "org.eclipse.cdt.dsf.debug.breakpoint.mi.number";
    public static final String TYPE = "org.eclipse.cdt.dsf.debug.breakpoint.mi.type";
    public static final String THREAD_ID = "org.eclipse.cdt.dsf.debug.breakpoint.mi.threadId";
    public static final String FULL_NAME = "org.eclipse.cdt.dsf.debug.breakpoint.mi.fullName";
    public static final String HITS = "org.eclipse.cdt.dsf.debug.breakpoint.mi.hits";
    public static final String IS_TEMPORARY = "org.eclipse.cdt.dsf.debug.breakpoint.mi.isTemporary";
    public static final String IS_HARDWARE = "org.eclipse.cdt.dsf.debug.breakpoint.mi.isHardware";
    public static final String LOCATION = "org.eclipse.cdt.dsf.debug.breakpoint.mi.location";
    private final MIBreakpoint fBreakpoint;
    private final Map<String, Object> fProperties;

    @Deprecated
    public MIBreakpointDMData(MIBreakpointDMData other) {
        this.fBreakpoint = new MIBreakpoint(other.fBreakpoint);
        this.fProperties = new HashMap<String, Object>(other.fProperties);
    }

    public MIBreakpointDMData copy() {
        return new MIBreakpointDMData(new MIBreakpoint(this.fBreakpoint), new HashMap<String, Object>(this.fProperties));
    }

    protected MIBreakpointDMData(MIBreakpoint dsfMIBreakpoint, HashMap<String, Object> properties) {
        this.fBreakpoint = dsfMIBreakpoint;
        if (properties != null) {
            this.fProperties = properties;
        } else {
            this.fProperties = new HashMap<String, Object>();
            if (dsfMIBreakpoint.isTracepoint()) {
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.type", "tracepoint");
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.fileName", dsfMIBreakpoint.getFile());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.lineNumber", dsfMIBreakpoint.getLine());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.function", dsfMIBreakpoint.getFunction());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.address", dsfMIBreakpoint.getAddress());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.condition", dsfMIBreakpoint.getCondition());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.passCount", dsfMIBreakpoint.getPassCount());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.isEnabled", dsfMIBreakpoint.isEnabled());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.commands", dsfMIBreakpoint.getCommands());
                this.fProperties.put(NUMBER, dsfMIBreakpoint.getNumber());
                this.fProperties.put(TYPE, dsfMIBreakpoint.getType());
                this.fProperties.put(THREAD_ID, dsfMIBreakpoint.getThreadId());
                this.fProperties.put(FULL_NAME, dsfMIBreakpoint.getFullName());
                this.fProperties.put(HITS, dsfMIBreakpoint.getTimes());
                this.fProperties.put(IS_TEMPORARY, dsfMIBreakpoint.isTemporary());
                this.fProperties.put(IS_HARDWARE, dsfMIBreakpoint.isHardware());
                this.fProperties.put(LOCATION, this.formatLocation());
            } else if (dsfMIBreakpoint.isDynamicPrintf()) {
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.type", "dynamicPrintf");
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.fileName", dsfMIBreakpoint.getFile());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.lineNumber", dsfMIBreakpoint.getLine());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.function", dsfMIBreakpoint.getFunction());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.address", dsfMIBreakpoint.getAddress());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.condition", dsfMIBreakpoint.getCondition());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.printf_string", dsfMIBreakpoint.getPrintfString());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.isEnabled", dsfMIBreakpoint.isEnabled());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.commands", dsfMIBreakpoint.getCommands());
                this.fProperties.put(NUMBER, dsfMIBreakpoint.getNumber());
                this.fProperties.put(TYPE, dsfMIBreakpoint.getType());
                this.fProperties.put(THREAD_ID, dsfMIBreakpoint.getThreadId());
                this.fProperties.put(FULL_NAME, dsfMIBreakpoint.getFullName());
                this.fProperties.put(HITS, dsfMIBreakpoint.getTimes());
                this.fProperties.put(IS_TEMPORARY, dsfMIBreakpoint.isTemporary());
                this.fProperties.put(IS_HARDWARE, dsfMIBreakpoint.isHardware());
                this.fProperties.put(LOCATION, this.formatLocation());
            } else if (dsfMIBreakpoint.isWatchpoint()) {
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.type", "watchpoint");
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.expression", dsfMIBreakpoint.getExpression());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.read", dsfMIBreakpoint.isAccessWatchpoint() || dsfMIBreakpoint.isReadWatchpoint());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.write", dsfMIBreakpoint.isAccessWatchpoint() || dsfMIBreakpoint.isWriteWatchpoint());
                this.fProperties.put(NUMBER, dsfMIBreakpoint.getNumber());
            } else if (dsfMIBreakpoint.isCatchpoint()) {
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.type", "catchpoint");
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.catchpoint_type", dsfMIBreakpoint.getCatchpointType());
                this.fProperties.put(NUMBER, dsfMIBreakpoint.getNumber());
            } else {
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.type", "breakpoint");
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.fileName", dsfMIBreakpoint.getFile());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.lineNumber", dsfMIBreakpoint.getLine());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.function", dsfMIBreakpoint.getFunction());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.address", dsfMIBreakpoint.getAddress());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.condition", dsfMIBreakpoint.getCondition());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.ignoreCount", dsfMIBreakpoint.getIgnoreCount());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.isEnabled", dsfMIBreakpoint.isEnabled());
                this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.commands", dsfMIBreakpoint.getCommands());
                this.fProperties.put(NUMBER, dsfMIBreakpoint.getNumber());
                this.fProperties.put(TYPE, dsfMIBreakpoint.getType());
                this.fProperties.put(THREAD_ID, dsfMIBreakpoint.getThreadId());
                this.fProperties.put(FULL_NAME, dsfMIBreakpoint.getFullName());
                this.fProperties.put(HITS, dsfMIBreakpoint.getTimes());
                this.fProperties.put(IS_TEMPORARY, dsfMIBreakpoint.isTemporary());
                this.fProperties.put(IS_HARDWARE, dsfMIBreakpoint.isHardware());
                this.fProperties.put(LOCATION, this.formatLocation());
            }
        }
    }

    @Deprecated
    public MIBreakpointDMData(MIBreakpoint dsfMIBreakpoint) {
        this(dsfMIBreakpoint, null);
    }

    protected Map<String, Object> getProperties() {
        return this.fProperties;
    }

    protected MIBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    private String formatLocation() {
        Object location = this.fBreakpoint.getAddress();
        String fileName = this.fBreakpoint.getFile();
        Integer lineNumber = this.fBreakpoint.getLine();
        String function = this.fBreakpoint.getFunction();
        if (!fileName.isEmpty()) {
            location = lineNumber != -1 ? fileName + ":" + String.valueOf(lineNumber) : fileName + ":" + function;
        }
        return location;
    }

    public boolean equals(MIBreakpointDMData other) {
        return this.fProperties.equals(other.fProperties);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MIBreakpointDMData)) {
            return false;
        }
        return this.equals((MIBreakpointDMData)other);
    }

    public int hashCode() {
        return this.fProperties.hashCode();
    }

    public String getBreakpointType() {
        return (String)this.fProperties.get("org.eclipse.cdt.dsf.debug.breakpoint.type");
    }

    public String getReference() {
        return this.fBreakpoint.getNumber();
    }

    public IAddress[] getAddresses() {
        IAddress[] addresses = new IAddress[]{new Addr64(this.fBreakpoint.getAddress())};
        return addresses;
    }

    public String getCondition() {
        return this.fBreakpoint.getCondition();
    }

    public String getExpression() {
        return this.fBreakpoint.getExpression();
    }

    public String getFileName() {
        return this.fBreakpoint.getFile();
    }

    public String getFunctionName() {
        return this.fBreakpoint.getFunction();
    }

    public int getIgnoreCount() {
        return this.fBreakpoint.getIgnoreCount();
    }

    public int getLineNumber() {
        return this.fBreakpoint.getLine();
    }

    public boolean isEnabled() {
        return this.fBreakpoint.isEnabled();
    }

    public int getPassCount() {
        return this.fBreakpoint.getPassCount();
    }

    public String getPrintfString() {
        return this.fBreakpoint.getPrintfString();
    }

    public String getCommands() {
        return this.fBreakpoint.getCommands();
    }

    public String getNumber() {
        return this.fBreakpoint.getNumber();
    }

    public String getThreadId() {
        return this.fBreakpoint.getThreadId();
    }

    public String[] getGroupIds() {
        return this.fBreakpoint.getGroupIds();
    }

    public void setGroupIds(String[] groups) {
        this.fBreakpoint.setGroupIds(groups);
    }

    public boolean isTemporary() {
        return this.fBreakpoint.isTemporary();
    }

    public boolean isHardware() {
        return this.fBreakpoint.isHardware();
    }

    public String getLocation() {
        return (String)this.fProperties.get(LOCATION);
    }

    public int getHits() {
        return this.fBreakpoint.getTimes();
    }

    public String getFullName() {
        return this.fBreakpoint.getFullName();
    }

    public String getType() {
        return this.fBreakpoint.getType();
    }

    public void setCondition(String condition) {
        this.fBreakpoint.setCondition(condition);
        this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.condition", condition);
    }

    public void setIgnoreCount(int ignoreCount) {
        this.fBreakpoint.setIgnoreCount(ignoreCount);
        this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.ignoreCount", ignoreCount);
    }

    public void setEnabled(boolean isEnabled) {
        this.fBreakpoint.setEnabled(isEnabled);
        this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.isEnabled", isEnabled);
    }

    public void setPassCount(int count) {
        this.fBreakpoint.setPassCount(count);
        this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.passCount", count);
    }

    public void setCommands(String commands) {
        this.fBreakpoint.setCommands(commands);
        this.fProperties.put("org.eclipse.cdt.dsf.debug.breakpoint.commands", commands);
    }

    public boolean isReadWatchpoint() {
        return this.fBreakpoint.isReadWatchpoint();
    }

    public boolean isWriteWatchpoint() {
        return this.fBreakpoint.isWriteWatchpoint();
    }

    public boolean isAccessWatchpoint() {
        return this.fBreakpoint.isAccessWatchpoint();
    }

    public boolean isPending() {
        return this.fBreakpoint.isPending();
    }

    @Deprecated
    public static enum MIBreakpointNature {
        UNKNOWN,
        BREAKPOINT,
        WATCHPOINT,
        CATCHPOINT,
        TRACEPOINT,
        DYNAMICPRINTF;

    }
}

