/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.query.arguments;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentsWizardPage;
import org.eclipse.swt.widgets.Composite;

public class ArgumentsWizard
extends Wizard {
    private IQueryContext context;
    private ArgumentSet argumentSet;

    public ArgumentsWizard(IQueryContext context, ArgumentSet argumentSet) {
        this.context = context;
        this.argumentSet = argumentSet;
        this.setWindowTitle(ArgumentsWizard.queryFullName(argumentSet.getQueryDescriptor()));
        this.setForcePreviousAndNextButtons(false);
        this.setDefaultPageImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/fill_arguments_wiz.gif"));
    }

    private static String queryFullName(QueryDescriptor query) {
        String categoryName;
        String name = query.getName();
        String category = query.getCategory();
        if (!"__hidden__".equals(category) && category != null && (categoryName = QueryRegistry.instance().getRootCategory().resolve(category).getFullName()) != null) {
            name = String.valueOf(categoryName) + " / " + name;
        }
        return name;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public IDialogSettings getDialogSettings() {
        IDialogSettings workbenchDialogSettings = MemoryAnalyserPlugin.getDefault().getDialogSettings();
        IDialogSettings result = workbenchDialogSettings.getSection(ArgumentsWizard.class.getName());
        if (result == null) {
            result = workbenchDialogSettings.addNewSection(ArgumentsWizard.class.getName());
        }
        return result;
    }

    public void addPages() {
        this.addPage((IWizardPage)new ArgumentsWizardPage(this.context, this.argumentSet));
    }

    public boolean performFinish() {
        return true;
    }
}

