/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.CheckOperationExecutor;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;

public class CheckConstant
implements ISearchOperation {
    private int position;
    private Object value;

    public CheckConstant(int position, Object value) {
        this.position = position;
        this.value = value;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor();
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Collections.singletonList(this.position);
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "check     constant " + variableMapping.apply(this.position) + "='" + String.valueOf(this.value) + "'";
    }

    private class Executor
    extends CheckOperationExecutor {
        private Executor() {
        }

        @Override
        protected boolean check(MatchingFrame frame, ISearchContext context) {
            return frame.get(CheckConstant.this.position).equals(CheckConstant.this.value);
        }

        @Override
        public ISearchOperation getOperation() {
            return CheckConstant.this;
        }
    }
}

