/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.copy.serializing;

import net.sourceforge.nattable.copy.command.CopyDataToClipboardCommand;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.serializing.ISerializer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class CopyDataToClipboardSerializer
implements ISerializer {
    private final LayerCell[][] copiedCells;
    private final CopyDataToClipboardCommand command;

    public CopyDataToClipboardSerializer(LayerCell[][] copiedCells, CopyDataToClipboardCommand command) {
        this.copiedCells = copiedCells;
        this.command = command;
    }

    public void serialize() {
        Clipboard clipboard = this.command.getClipboard();
        String cellDelimeter = this.command.getCellDelimeter();
        String rowDelimeter = this.command.getRowDelimeter();
        TextTransfer textTransfer = TextTransfer.getInstance();
        StringBuilder textData = new StringBuilder();
        int currentRow = 0;
        LayerCell[][] layerCellArray = this.copiedCells;
        int n = this.copiedCells.length;
        int n2 = 0;
        while (n2 < n) {
            LayerCell[] cells = layerCellArray[n2];
            int currentCell = 0;
            LayerCell[] layerCellArray2 = cells;
            int n3 = cells.length;
            int n4 = 0;
            while (n4 < n3) {
                String delimeter;
                LayerCell cell = layerCellArray2[n4];
                String string = delimeter = ++currentCell < cells.length ? cellDelimeter : "";
                if (cell != null) {
                    textData.append(cell.getDataValue() + delimeter);
                } else {
                    textData.append(delimeter);
                }
                ++n4;
            }
            if (++currentRow < this.copiedCells.length) {
                textData.append(rowDelimeter);
            }
            ++n2;
        }
        clipboard.setContents(new Object[]{textData.toString()}, new Transfer[]{textTransfer});
    }
}

