/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.layer;

import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeConfig {
    public static final String PERSISTENCE_KEY_DEFAULT_SIZE = ".defaultSize";
    public static final String PERSISTENCE_KEY_DEFAULT_SIZES = ".defaultSizes";
    public static final String PERSISTENCE_KEY_SIZES = ".sizes";
    public static final String PERSISTENCE_KEY_RESIZABLE_BY_DEFAULT = ".resizableByDefault";
    public static final String PERSISTENCE_KEY_RESIZABLE_INDEXES = ".resizableIndexes";
    private int defaultSize;
    private final Map<Integer, Integer> defaultSizeMap = new TreeMap<Integer, Integer>();
    private final Map<Integer, Integer> sizeMap = new TreeMap<Integer, Integer>();
    private final Map<Integer, Boolean> resizablesMap = new TreeMap<Integer, Boolean>();
    private boolean resizableByDefault = true;

    public SizeConfig() {
    }

    public SizeConfig(int defaultSize) {
        this.defaultSize = defaultSize;
    }

    public void saveState(String prefix, Properties properties) {
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZE, String.valueOf(this.defaultSize));
        this.saveMap(this.defaultSizeMap, String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZES, properties);
        this.saveMap(this.sizeMap, String.valueOf(prefix) + PERSISTENCE_KEY_SIZES, properties);
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_BY_DEFAULT, String.valueOf(this.resizableByDefault));
        this.saveMap(this.resizablesMap, String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_INDEXES, properties);
    }

    private void saveMap(Map<Integer, ?> map, String key, Properties properties) {
        if (map.size() > 0) {
            StringBuilder strBuilder = new StringBuilder();
            for (Integer index : map.keySet()) {
                strBuilder.append(index);
                strBuilder.append(':');
                strBuilder.append(map.get(index));
                strBuilder.append(',');
            }
            properties.setProperty(key, strBuilder.toString());
        }
    }

    public void loadState(String prefix, Properties properties) {
        String persistedResizableDefault;
        String persistedDefaultSize = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZE);
        if (!StringUtils.isEmpty((String)persistedDefaultSize)) {
            this.defaultSize = Integer.valueOf(persistedDefaultSize);
        }
        if (!StringUtils.isEmpty((String)(persistedResizableDefault = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_BY_DEFAULT)))) {
            this.resizableByDefault = Boolean.valueOf(persistedResizableDefault);
        }
        this.loadBooleanMap(String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_INDEXES, properties, this.resizablesMap);
        this.loadIntegerMap(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZES, properties, this.defaultSizeMap);
        this.loadIntegerMap(String.valueOf(prefix) + PERSISTENCE_KEY_SIZES, properties, this.sizeMap);
    }

    private void loadIntegerMap(String key, Properties properties, Map<Integer, Integer> map) {
        String property = properties.getProperty(key);
        if (property != null) {
            map.clear();
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int separatorIndex = token.indexOf(58);
                map.put(Integer.valueOf(token.substring(0, separatorIndex)), Integer.valueOf(token.substring(separatorIndex + 1)));
            }
        }
    }

    private void loadBooleanMap(String key, Properties properties, Map<Integer, Boolean> map) {
        String property = properties.getProperty(key);
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int separatorIndex = token.indexOf(58);
                map.put(Integer.valueOf(token.substring(0, separatorIndex)), Boolean.valueOf(token.substring(separatorIndex + 1)));
            }
        }
    }

    public void setDefaultSize(int defaultSize) {
        this.defaultSize = defaultSize;
    }

    public void setDefaultSize(int position, int size) {
        this.defaultSizeMap.put(position, size);
    }

    private int getDefaultSize(int position) {
        int size = this.getSize(this.defaultSizeMap, position);
        if (size >= 0) {
            return size;
        }
        return this.defaultSize;
    }

    public int getAggregateSize(int position) {
        if (position < 0) {
            return -1;
        }
        if (position == 0) {
            return 0;
        }
        if (this.isAllPositionsSameSize()) {
            return position * this.defaultSize;
        }
        int resizeAggregate = 0;
        int resizedColumns = 0;
        for (Integer resizedPosition : this.sizeMap.keySet()) {
            if (resizedPosition >= position) break;
            ++resizedColumns;
            resizeAggregate += this.sizeMap.get(resizedPosition).intValue();
        }
        return position * this.defaultSize + (resizeAggregate - resizedColumns * this.defaultSize);
    }

    public int getSize(int position) {
        int size = this.getSize(this.sizeMap, position);
        if (size <= 0 && this.sizeMap.containsKey(position)) {
            return 5;
        }
        if (size >= 0) {
            return size;
        }
        return this.getDefaultSize(position);
    }

    public void setSize(int position, int size) {
        if (this.isPositionResizable(position)) {
            this.sizeMap.put(position, size);
        }
    }

    public boolean isResizableByDefault() {
        return this.resizableByDefault;
    }

    public boolean isPositionResizable(int position) {
        Boolean resizable = this.resizablesMap.get(position);
        if (resizable != null) {
            return resizable;
        }
        return this.resizableByDefault;
    }

    public void setPositionResizable(int position, boolean resizable) {
        this.resizablesMap.put(position, resizable);
    }

    public void setResizableByDefault(boolean resizableByDefault) {
        this.resizablesMap.clear();
        this.resizableByDefault = resizableByDefault;
    }

    public boolean isAllPositionsSameSize() {
        return this.defaultSizeMap.size() == 0 && this.sizeMap.size() == 0;
    }

    private int getSize(Map<Integer, Integer> map, int position) {
        Integer sizeFromMap = map.get(position);
        if (sizeFromMap != null) {
            return sizeFromMap;
        }
        return -1;
    }
}

