/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.selection;

import net.sourceforge.nattable.command.ILayerCommandHandler;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.selection.SelectionUtils;
import net.sourceforge.nattable.selection.command.SelectCellCommand;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectCellCommandHandler
implements ILayerCommandHandler<SelectCellCommand> {
    private final SelectionLayer selectionLayer;

    public SelectCellCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, SelectCellCommand command) {
        if (command.convertToTargetLayer(this.selectionLayer)) {
            this.toggleCell(command.getColumnPosition(), command.getRowPosition(), command.isShiftMask(), command.isControlMask(), command.isForcingEntireCellIntoViewport());
            this.selectionLayer.fireCellSelectionEvent(command.getColumnPosition(), command.getRowPosition(), command.isForcingEntireCellIntoViewport(), command.isShiftMask(), command.isControlMask());
            return true;
        }
        return false;
    }

    protected void toggleCell(int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask, boolean forcingEntireCellIntoViewport) {
        boolean selectCell = true;
        if (SelectionUtils.isControlOnly(withShiftMask, withControlMask) && this.selectionLayer.isCellPositionSelected(columnPosition, rowPosition)) {
            this.selectionLayer.clearSelection(columnPosition, rowPosition);
            selectCell = false;
        }
        if (selectCell) {
            this.selectCell(columnPosition, rowPosition, withShiftMask, withControlMask);
        }
    }

    public void selectCell(int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask) {
        if (!withShiftMask && !withControlMask) {
            this.selectionLayer.clear();
        }
        this.selectionLayer.setLastSelectedCell(columnPosition, rowPosition);
        if (withShiftMask && this.selectionLayer.lastSelectedRegion != null && this.selectionLayer.hasRowSelection()) {
            this.selectionLayer.lastSelectedRegion.height = Math.abs(this.selectionLayer.selectionAnchor.rowPosition - rowPosition) + 1;
            this.selectionLayer.lastSelectedRegion.y = Math.min(this.selectionLayer.selectionAnchor.rowPosition, rowPosition);
            this.selectionLayer.lastSelectedRegion.width = Math.abs(this.selectionLayer.selectionAnchor.columnPosition - columnPosition) + 1;
            this.selectionLayer.lastSelectedRegion.x = Math.min(this.selectionLayer.selectionAnchor.columnPosition, columnPosition);
            this.selectionLayer.addSelection(this.selectionLayer.lastSelectedRegion);
        } else {
            this.selectionLayer.lastSelectedRegion = null;
            Rectangle selection = null;
            selection = new Rectangle(this.selectionLayer.lastSelectedCell.columnPosition, this.selectionLayer.lastSelectedCell.rowPosition, 1, 1);
            this.selectionLayer.addSelection(selection);
        }
    }

    @Override
    public Class<SelectCellCommand> getCommandClass() {
        return SelectCellCommand.class;
    }
}

