/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.style.editor;

import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.style.editor.AbstractEditorPanel;
import net.sourceforge.nattable.style.editor.ColorPicker;
import net.sourceforge.nattable.style.editor.FontPicker;
import net.sourceforge.nattable.style.editor.GridStyleParameterObject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridColorsEditorPanel
extends AbstractEditorPanel<GridStyleParameterObject> {
    private FontPicker fontPicker;
    private ColorPicker evenRowColorPicker;
    private ColorPicker oddRowColorPicker;
    private ColorPicker selectionColorPicker;
    private IConfigRegistry configRegistry;

    public GridColorsEditorPanel(Composite parent, GridStyleParameterObject currentStyle) {
        super(parent, 0);
    }

    @Override
    public String getEditorName() {
        return "Grid colors";
    }

    @Override
    public GridStyleParameterObject getNewValue() {
        GridStyleParameterObject newStyle = new GridStyleParameterObject(this.configRegistry);
        newStyle.tableFont = this.fontPicker.getSelectedFont();
        newStyle.evenRowColor = this.evenRowColorPicker.getSelectedColor();
        newStyle.oddRowColor = this.oddRowColorPicker.getSelectedColor();
        newStyle.selectionColor = this.selectionColorPicker.getSelectedColor();
        return newStyle;
    }

    @Override
    public void edit(GridStyleParameterObject currentStyle) throws Exception {
        this.configRegistry = currentStyle.getConfigRegistry();
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 10;
        this.setLayout((Layout)layout);
        new Label((Composite)this, 0).setText("Font");
        this.fontPicker = new FontPicker(this, currentStyle.tableFont);
        this.fontPicker.setLayoutData(new GridData(100, 22));
        new Label((Composite)this, 0).setText("Even row color");
        this.evenRowColorPicker = new ColorPicker(this, currentStyle.evenRowColor);
        new Label((Composite)this, 0).setText("Odd row color");
        this.oddRowColorPicker = new ColorPicker(this, currentStyle.oddRowColor);
        new Label((Composite)this, 0).setText("Selection Color");
        this.selectionColorPicker = new ColorPicker(this, currentStyle.selectionColor);
    }
}

