/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.accservice.swtbridge.internal.ia2;

import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleImage;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleImage;
import org.eclipse.actf.util.win32.NativeIntAccess;
import org.eclipse.actf.util.win32.NativeStringAccess;
import org.eclipse.swt.graphics.Point;

public class InternalAccessibleImage
implements AccessibleImage {
    private IAccessibleImage accessibleImage = null;

    public InternalAccessibleImage(int n) {
        this.accessibleImage = new IAccessibleImage(n);
        this.accessibleImage.AddRef();
    }

    public void dispose() {
        if (this.accessibleImage != null) {
            this.accessibleImage.Release();
            this.accessibleImage = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public String getAccessibleImageDescription() {
        if (this.accessibleImage != null) {
            NativeStringAccess nativeStringAccess = new NativeStringAccess();
            try {
                if (this.accessibleImage.get_description(nativeStringAccess.getAddress()) == 0) {
                    String string = nativeStringAccess.getString();
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeStringAccess.dispose();
            }
        }
        return null;
    }

    public Point getAccessibleImagePosition(int n) {
        if (this.accessibleImage != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleImage.get_imagePosition(n, nativeIntAccess.getAddress(0), nativeIntAccess.getAddress(1)) == 0) {
                    Point point = new Point(nativeIntAccess.getInt(0), nativeIntAccess.getInt(1));
                    return point;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public Point getAccessibleImageSize() {
        if (this.accessibleImage != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleImage.get_imageSize(nativeIntAccess.getAddress(0), nativeIntAccess.getAddress(1)) == 0) {
                    Point point = new Point(nativeIntAccess.getInt(0), nativeIntAccess.getInt(1));
                    return point;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }
}

