/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.lang.reflect.Field;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.model.RuleFactory;
import org.eclipse.bpel.validator.model.Validator;

public class CValidator
extends Validator {
    protected INode fParentNode;
    protected List<INode> fChildren;
    List<INode> fTypeToCheckList;

    @Override
    protected void start() {
        super.start();
        this.fParentNode = this.mNode.parentNode();
        this.fChildren = this.mNode.children();
    }

    @ARule(sa=2001, desc="Check to make sure that my parent node is within a set of allowed nodes", author="michal.chmielewski@oracle.com", date="02/15/2007", errors="BPELC__WRONG_PARENT")
    public void rule_CheckParentNode_1() {
        this.checkParentNode();
    }

    public void checkParentNode() {
        IFilter<INode> filter = this.parentNodeNames();
        if (this.fParentNode == null) {
            return;
        }
        if (filter.select(this.fParentNode)) {
            return;
        }
        IProblem problem = this.createError();
        problem.fill("BPELC__WRONG_PARENT", this.toString(this.mNode.nodeName()), this.toString(this.fParentNode.nodeName()), filter.toString());
        this.disableRules();
    }

    @ARule(sa=2002, desc="Check my children nodes (types and occurances)", author="michal.chmielewski@oracle.com", date="02/15/2007", errors="BPELC__MIN_IN_PARENT,BPELC__MAX_IN_PARENT")
    public void rule_CheckChildrenNodes_0() {
        this.checkChildren();
    }

    public void checkChildren() {
    }

    public int checkChild(QName node, int min, int max) {
        return this.checkChild(new NodeNameFilter(node), min, max);
    }

    public int checkChild(IFilter<INode> filter, int min, int max) {
        IProblem problem;
        int count = 0;
        for (INode n : this.fChildren) {
            if (!filter.select(n)) continue;
            ++count;
        }
        if (count < min) {
            problem = this.createError();
            problem.fill("BPELC__MIN_IN_PARENT", this.toString(this.mNode.nodeName()), this.getNodeKind(this.mNode), 0, filter.toString(), count, min);
        } else if (count > max) {
            problem = this.createError();
            problem.fill("BPELC__MAX_IN_PARENT", this.toString(this.mNode.nodeName()), this.getNodeKind(this.mNode), 0, filter.toString(), count, max);
        }
        return count;
    }

    public IFilter<INode> parentNodeNames() {
        try {
            Field f = this.getClass().getField("PARENTS");
            return (IFilter)f.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return Filters.EMPTY;
    }

    public String getExitOnStandardFault(INode node) {
        INode nn = mSelector.selectParent(node, new IFilter<INode>(){

            @Override
            public boolean select(INode n) {
                QName name = n.nodeName();
                if (!name.equals(ND_SCOPE) && !name.equals(ND_PROCESS)) {
                    return false;
                }
                String value = n.getAttribute(AT_EXIT_ON_STANDARD_FAULT);
                return !CValidator.isEmpty(value);
            }
        });
        if (nn != null) {
            return nn.getAttribute(AT_EXIT_ON_STANDARD_FAULT);
        }
        return "no";
    }

    public void registerTypeToCheck(INode node) {
        if (this.isUndefined(node)) {
            return;
        }
        if (this.fTypeToCheckList == null) {
            INode process = this.mNode.rootNode();
            this.fTypeToCheckList = this.getValue(process, "types.to.check", null);
        }
        if (this.fTypeToCheckList == null) {
            return;
        }
        if (!this.fTypeToCheckList.contains(node)) {
            this.fTypeToCheckList.add(node);
        }
    }

    public void compatibleCopyCheck(INode fromNode, INode toNode) {
        INode fromTypeNode = this.getValue(fromNode, "type", null);
        INode toTypeNode = this.getValue(toNode, "type", null);
        if (this.hasProblems(fromNode) || this.hasProblems(toNode)) {
            return;
        }
        if (fromTypeNode == null && toTypeNode == null) {
            return;
        }
        if (fromTypeNode == null || toTypeNode == null) {
            IProblem problem = this.createInfo();
            problem.fill("BPELC_COPY__NOT_CHECKED", this.toString(this.mNode.nodeName()), "text.term.from", fromTypeNode == null ? "text.term.unspecified" : fromTypeNode, "text.term.to", toTypeNode == null ? "text.term.unspecified" : toTypeNode);
            return;
        }
        String fHeaderName = this.getValue(fromNode, "header", null);
        if (!CValidator.isEmpty(fHeaderName)) {
            return;
        }
        boolean bCompatible = this.mModelQuery.check(2, fromTypeNode, toTypeNode);
        if (this.mModelQuery.check(1, fromTypeNode, null) && this.mModelQuery.check(1, toTypeNode, null)) {
            if (!bCompatible) {
                IProblem problem = this.createWarning();
                problem.fill("BPELC_COPY__INCOMPATIBLE_SIMPLE", this.toString(this.mNode.nodeName()), "text.term.from", fromTypeNode, "text.term.to", toTypeNode);
            }
            String fromPart = fromNode.getAttribute(AT_PART);
            String toPart = toNode.getAttribute(AT_PART);
            if (fromPart != null || toPart != null) {
                return;
            }
        } else if (!bCompatible) {
            IProblem problem = this.createError();
            problem.fill("BPELC_COPY__INCOMPATIBLE", this.toString(this.mNode.nodeName()), "text.term.from", fromTypeNode, "text.term.to", toTypeNode, this.mModelQuery.getDiagnostic(0));
        }
    }

    public String getAttribute(INode node, QName name, int kind, IFilter<String> filter, boolean bMandatory) {
        String value = node.getAttribute(name);
        if (bMandatory && CValidator.isEmpty(value)) {
            IProblem problem = this.createError(node);
            problem.setAttribute("context.name", name.getLocalPart());
            problem.fill("BPELC__UNSET_ATTRIBUTE", this.toString(node.nodeName()), this.toString(name), kind);
            return null;
        }
        if (filter == null || CValidator.isEmpty(value)) {
            return value;
        }
        if (filter.select(value)) {
            return value;
        }
        IProblem problem = this.createError(node);
        problem.setAttribute("context.name", name.getLocalPart());
        problem.fill("BPELC__INVALID_ATTRIBUTE_VALUE", this.toString(node.nodeName()), this.toString(name), value, filter.toString(), kind);
        return null;
    }

    public boolean checkAttributeNode(INode node, INode ref, QName name, int kind) {
        if (ref == null) {
            IProblem problem = this.createError(node);
            problem.setAttribute("context.name", name);
            problem.fill("BPELC__UNSET_ATTRIBUTE", this.toString(node.nodeName()), this.toString(name), kind);
            return false;
        }
        if (!ref.isResolved()) {
            String atValue = node.getAttribute(name);
            IProblem problem = this.createError(node);
            problem.setAttribute("context.name", name);
            problem.fill("BPELC__UNRESOLVED_ATTRIBUTE", this.toString(node.nodeName()), this.toString(name), kind, atValue);
            return false;
        }
        return true;
    }

    public boolean checkNCName(INode node, String ncName, QName atName) {
        if (ncName == null || ncName.length() == 0) {
            IProblem problem = this.createError(node);
            problem.setAttribute("context.name", atName.getLocalPart());
            problem.fill("BPELC__UNSET_ATTRIBUTE", this.toString(node.nodeName()), atName, 0);
            return false;
        }
        if (!Filters.NC_NAME.select(ncName)) {
            IProblem problem = this.createError(node);
            problem.setAttribute("context.name", atName.getLocalPart());
            problem.fill("General.NCName_Bad", this.toString(atName), this.toString(node.nodeName()), ncName);
            return false;
        }
        return true;
    }

    public boolean checkValidator(INode node, INode ref, QName name, int kind) {
        if (ref == null) {
            return false;
        }
        Validator validator = ref.nodeValidator();
        if (validator == null) {
            return true;
        }
        if (validator.hasProblems()) {
            IProblem problem = this.createWarning(node);
            problem.setAttribute("context.name", name.getLocalPart());
            problem.fill("BPELC_REF_NODE_PROBLEMS", this.toString(node.nodeName()), this.toString(ref.nodeName()), name, kind);
            return false;
        }
        return true;
    }

    public String getLanguage(INode node, QName atName) {
        String lang = node.getAttribute(atName);
        if (lang == null) {
            INode process = node.rootNode();
            lang = process.getAttribute(atName);
        }
        if (lang == null) {
            return "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0";
        }
        return lang;
    }

    protected int getNodeKind(INode node) {
        if (Filters.ACTIVITIES.select(node)) {
            return 1;
        }
        return 0;
    }

    protected Validator createExpressionValidator(QName qname) {
        Validator object = RuleFactory.INSTANCE.createValidator(qname);
        if (object == null) {
            IProblem problem = this.createWarning();
            problem.fill("BPELC__NO_EXPRESSION_VALIDATOR", this.toString(this.mNode.nodeName()), qname.getNamespaceURI());
            return null;
        }
        return object;
    }
}

