/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.cxx.model;

import java.util.WeakHashMap;
import org.eclipse.cdt.codan.core.cxx.internal.model.CodanCommentMap;
import org.eclipse.cdt.codan.core.cxx.internal.model.cfg.CxxControlFlowGraph;
import org.eclipse.cdt.codan.core.cxx.model.ICodanCommentMap;
import org.eclipse.cdt.codan.core.model.ICodanDisposable;
import org.eclipse.cdt.codan.core.model.cfg.IControlFlowGraph;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.ASTCommenter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;

public class CxxModelsCache
implements ICodanDisposable {
    private static final int PARSE_MODE = 230;
    private final IFile file;
    private final ITranslationUnit tu;
    private IASTTranslationUnit ast;
    private IIndex index;
    private final WeakHashMap<IASTFunctionDefinition, IControlFlowGraph> cfgmap;
    private ICodanCommentMap commentMap;
    private boolean disposed;

    CxxModelsCache(ITranslationUnit tu) {
        this.tu = tu;
        this.file = tu != null ? (IFile)tu.getResource() : null;
        this.cfgmap = new WeakHashMap(0);
    }

    CxxModelsCache(IASTTranslationUnit ast) {
        this(ast.getOriginatingTranslationUnit());
        this.ast = ast;
    }

    public IASTTranslationUnit getAST() throws OperationCanceledException, CoreException {
        return this.getAST(this.tu);
    }

    public IASTTranslationUnit getAST(ITranslationUnit tu) throws OperationCanceledException, CoreException {
        if (!this.tu.equals(tu)) {
            throw new IllegalArgumentException();
        }
        if (this.ast == null) {
            this.getIndex();
            this.ast = tu.getAST(this.index, 230);
        }
        return this.ast;
    }

    public ITranslationUnit getTranslationUnit() {
        return this.tu;
    }

    public IFile getFile() {
        return this.file;
    }

    public synchronized IControlFlowGraph getControlFlowGraph(IASTFunctionDefinition func) {
        Object cfg = this.cfgmap.get(func);
        if (cfg != null) {
            return cfg;
        }
        cfg = CxxControlFlowGraph.build(func);
        if (this.cfgmap.size() > 20) {
            this.cfgmap.clear();
        }
        this.cfgmap.put(func, (IControlFlowGraph)cfg);
        return cfg;
    }

    public synchronized ICodanCommentMap getCommentedNodeMap() {
        return this.getCommentedNodeMap(this.tu);
    }

    public synchronized ICodanCommentMap getCommentedNodeMap(ITranslationUnit tu) {
        if (!this.tu.equals(tu)) {
            throw new IllegalArgumentException();
        }
        if (this.commentMap == null) {
            if (this.ast == null) {
                throw new IllegalStateException("getCommentedNodeMap called before getAST");
            }
            this.commentMap = new CodanCommentMap(ASTCommenter.getCommentedNodeMap((IASTTranslationUnit)this.ast));
        }
        return this.commentMap;
    }

    public synchronized IIndex getIndex() throws CoreException, OperationCanceledException {
        Assert.isTrue((!this.disposed ? 1 : 0) != 0, (String)"CxxASTCache is already disposed.");
        if (this.index == null) {
            ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
            IIndex index = CCorePlugin.getIndexManager().getIndex(projects);
            try {
                index.acquireReadLock();
            }
            catch (InterruptedException e) {
                throw new OperationCanceledException();
            }
            this.index = index;
        }
        return this.index;
    }

    public void dispose() {
        Assert.isTrue((!this.disposed ? 1 : 0) != 0, (String)"CxxASTCache.dispose() called more than once.");
        this.disposed = true;
        if (this.index != null) {
            this.index.releaseReadLock();
        }
    }
}

