/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.ui.internal.Logger;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.editor.CloudFoundryApplicationsEditorPage;
import org.eclipse.cft.server.ui.internal.editor.ServicesHandler;
import org.eclipse.cft.server.ui.internal.wizards.ServiceToApplicationsBindingWizard;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.progress.UIJob;

public class ServiceToApplicationsBindingAction
extends Action {
    private final CloudFoundryServerBehaviour serverBehaviour;
    private final ServicesHandler servicesHandler;
    private final CloudFoundryApplicationsEditorPage editorPage;

    public ServiceToApplicationsBindingAction(IStructuredSelection selection, CloudFoundryServerBehaviour serverBehaviour, CloudFoundryApplicationsEditorPage editorPage) {
        this.serverBehaviour = serverBehaviour;
        this.editorPage = editorPage;
        this.setText(Messages.MANAGE_SERVICES_TO_APPLICATIONS_ACTION);
        this.servicesHandler = new ServicesHandler(selection);
    }

    public void run() {
        UIJob uiJob = new UIJob(Messages.MANAGE_SERVICES_TO_APPLICATIONS_TITLE){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                block3: {
                    try {
                        if (ServiceToApplicationsBindingAction.this.serverBehaviour != null) {
                            ServiceToApplicationsBindingWizard wizard = new ServiceToApplicationsBindingWizard(ServiceToApplicationsBindingAction.this.servicesHandler, ServiceToApplicationsBindingAction.this.serverBehaviour.getCloudFoundryServer(), ServiceToApplicationsBindingAction.this.editorPage);
                            WizardDialog dialog = new WizardDialog(ServiceToApplicationsBindingAction.this.editorPage.getSite().getShell(), (IWizard)wizard);
                            dialog.open();
                        }
                    }
                    catch (CoreException e) {
                        if (!Logger.ERROR) break block3;
                        Logger.println("/debug/error", (Object)this, "runInUIThread", "Error launching wizard", (Throwable)e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(true);
        uiJob.setPriority(10);
        uiJob.schedule();
    }
}

