/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.util;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.util.Strings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class CodeGeneration {
    public static String evaluateTemplate(TemplateContext context, Template template, String[] fullLineVariables) throws CoreException {
        String str;
        block6: {
            TemplateBuffer buffer;
            block5: {
                buffer = context.evaluate(template);
                if (buffer != null) break block5;
                return null;
            }
            str = CodeGeneration.fixFullLineVariables(buffer, fullLineVariables);
            if (!Strings.containsOnlyWhitespaces(str)) break block6;
            return null;
        }
        try {
            return str;
        }
        catch (BadLocationException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    private static String fixFullLineVariables(TemplateBuffer buffer, String[] variables) throws MalformedTreeException, BadLocationException {
        Document doc = new Document(buffer.getString());
        int nLines = doc.getNumberOfLines();
        MultiTextEdit edit = new MultiTextEdit();
        HashSet<Integer> removedLines = new HashSet<Integer>();
        int i = 0;
        while (i < variables.length) {
            TemplateVariable position = CodeGeneration.findVariable(buffer, variables[i]);
            if (position != null) {
                int[] offsets;
                if (position.getLength() > 0) {
                    offsets = position.getOffsets();
                    int j = 0;
                    while (j < offsets.length) {
                        block10: {
                            int offset = offsets[j];
                            try {
                                int startLine = doc.getLineOfOffset(offset);
                                int startOffset = doc.getLineOffset(startLine);
                                int endLine = doc.getLineOfOffset(offset + position.getLength());
                                String prefix = doc.get(startOffset, offset - startOffset);
                                if (prefix.length() <= 0 || startLine >= endLine) break block10;
                                int line = startLine + 1;
                                while (line <= endLine) {
                                    int lineOffset = doc.getLineOffset(line);
                                    edit.addChild((TextEdit)new InsertEdit(lineOffset, prefix));
                                    ++line;
                                }
                            }
                            catch (BadLocationException exc) {
                                break;
                            }
                        }
                        ++j;
                    }
                } else {
                    offsets = position.getOffsets();
                    int k = 0;
                    while (k < offsets.length) {
                        int line = doc.getLineOfOffset(offsets[k]);
                        IRegion lineInfo = doc.getLineInformation(line);
                        int offset = lineInfo.getOffset();
                        String str = doc.get(offset, lineInfo.getLength());
                        if (Strings.containsOnlyWhitespaces(str) && nLines > line + 1 && removedLines.add(line)) {
                            int nextStart = doc.getLineOffset(line + 1);
                            int length = nextStart - offset;
                            edit.addChild((TextEdit)new DeleteEdit(offset, length));
                        }
                        ++k;
                    }
                }
            }
            ++i;
        }
        edit.apply((IDocument)doc, 0);
        return doc.get();
    }

    private static TemplateVariable findVariable(TemplateBuffer buffer, String variable) {
        TemplateVariable[] positions = buffer.getVariables();
        int i = 0;
        while (i < positions.length) {
            TemplateVariable curr = positions[i];
            if (variable.equals(curr.getType())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    public static String getLineDelimiterUsed(IModelElement elem) throws ModelException {
        if (elem == null) {
            return "";
        }
        ISourceModule cu = (ISourceModule)elem.getAncestor(5);
        if (cu != null && cu.exists()) {
            IBuffer buf = cu.getBuffer();
            int length = buf.getLength();
            int i = 0;
            while (i < length) {
                char ch = buf.getChar(i);
                if (ch == '\r') {
                    if (i + 1 < length && buf.getChar(i + 1) == '\n') {
                        return "\r\n";
                    }
                    return "\r";
                }
                if (ch == '\n') {
                    return "\n";
                }
                ++i;
            }
        }
        return CodeGeneration.getProjectLineDelimiter(elem.getScriptProject());
    }

    private static String getProjectLineDelimiter(IScriptProject cProject) {
        String lineDelimiter;
        IProject project = null;
        if (cProject != null) {
            project = cProject.getProject();
        }
        if ((lineDelimiter = CodeGeneration.getLineDelimiterPreference(project)) != null) {
            return lineDelimiter;
        }
        return Util.LINE_SEPARATOR;
    }

    public static String getLineDelimiterPreference(IProject project) {
        IScopeContext[] scopeContext;
        if (project != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(project)};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{InstanceScope.INSTANCE};
        String platformDefault = System.getProperty("line.separator", "\n");
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", platformDefault, scopeContext);
    }
}

