/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.helper.URIHelper;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class PatternMethodEditorInput
implements IFileEditorInput {
    public static final String PATTERN_METHOD_ID = "methodId";
    public static final String RESSOURCE_URI = "uri";
    private final PatternPersistableElement _persistable = new PatternPersistableElement();
    private PatternMethod _method;
    private final Resource _resource;

    public PatternMethodEditorInput(Resource resource, String fragment) {
        this._resource = resource;
        this._method = (PatternMethod)resource.getEObject(fragment);
    }

    public boolean exists() {
        return true;
    }

    public PatternMethod getPatternMethod() {
        return this._method;
    }

    public Resource getResource() {
        return this._resource;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.getPatternMethod().getName();
    }

    public IPersistableElement getPersistable() {
        return this._persistable;
    }

    public String getToolTipText() {
        if (this.getPatternMethod() != null) {
            return this.getPatternMethod().getName();
        }
        return Messages.input_tooltip;
    }

    public Object getAdapter(Class adapter) {
        if (IFile.class == adapter) {
            return this.getFile();
        }
        return null;
    }

    public IFile getFile() {
        IProject project = EMFHelper.getProject((Resource)this.getResource());
        if (project == null) {
            return null;
        }
        IFile file = project.getFile(URIHelper.toPlatformProjectString((URI)this.getPatternMethod().getPatternFilePath(), (boolean)true));
        if (file != null && file.exists()) {
            return file;
        }
        try {
            file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return file;
    }

    public IStorage getStorage() throws CoreException {
        return this.getFile();
    }

    private class PatternPersistableElement
    implements IPersistableElement {
        private PatternPersistableElement() {
        }

        public void saveState(IMemento memento) {
            memento.putString(PatternMethodEditorInput.PATTERN_METHOD_ID, PatternMethodEditorInput.this.getPatternMethod().getID());
            memento.putString(PatternMethodEditorInput.RESSOURCE_URI, PatternMethodEditorInput.this._resource.getURI().toString());
        }

        public String getFactoryId() {
            return "org.eclipse.egf.pattern.ui.pattern.factory.id";
        }
    }
}

