/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.analyzer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.util.CDOFetchRule;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.internal.cdo.analyzer.CDOAbstractFeatureRuleAnalyzer;
import org.eclipse.emf.internal.cdo.analyzer.CDOClusterOfFetchRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOFeatureAnalyzerUI
extends CDOAbstractFeatureRuleAnalyzer {
    private static final long ELAPSE_TIME = 400L;
    private Map<CDOClusterOfFetchRule, CDOClusterOfFetchRule> featureRules = new HashMap<CDOClusterOfFetchRule, CDOClusterOfFetchRule>();
    private CDOClusterOfFetchRule currentClusterOfFetchRule;
    private long maxTimeBetweenOperation;

    public CDOFeatureAnalyzerUI() {
        this(400L);
    }

    public CDOFeatureAnalyzerUI(long maxTimeBetweenOperation) {
        this.maxTimeBetweenOperation = maxTimeBetweenOperation;
    }

    @Override
    public CDOID getContext() {
        if (this.lastTraverseFeature.isMany()) {
            return CDOID.NULL;
        }
        return this.lastTraverseCDOObject.cdoID();
    }

    public synchronized CDOClusterOfFetchRule getFeatureRule(EClass eClass, EStructuralFeature feature) {
        CDOClusterOfFetchRule search = new CDOClusterOfFetchRule(eClass, feature);
        CDOClusterOfFetchRule featureRule = this.featureRules.get(search);
        if (featureRule == null) {
            featureRule = search;
            this.featureRules.put(search, featureRule);
        }
        return featureRule;
    }

    @Override
    public List<CDOFetchRule> getFetchRules(Collection<CDOID> ids) {
        ArrayList<CDOFetchRule> list = new ArrayList<CDOFetchRule>();
        boolean addRootFeature = true;
        if (this.lastTraverseFeature != null) {
            CDOClusterOfFetchRule search;
            CDOClusterOfFetchRule fetchOfRule;
            this.fetchData();
            if (this.lastTraverseFeature.isMany()) {
                addRootFeature = false;
            }
            if ((fetchOfRule = this.featureRules.get(search = new CDOClusterOfFetchRule(this.lastTraverseCDOObject.eClass(), this.lastTraverseFeature))) == null) {
                return null;
            }
            Collection<CDOFetchRule> fetchRules = fetchOfRule.getFeatureInfo().getRules(null, null);
            for (CDOFetchRule fetchRule : fetchRules) {
                if (!addRootFeature && this.lastTraverseCDOObject.eClass() == fetchRule.getEClass()) continue;
                list.add(fetchRule);
            }
        }
        return list;
    }

    @Override
    protected void doPreTraverseFeature(CDOObject cdoObject, EStructuralFeature feature, int index) {
        if (feature instanceof EReference && (this.lastElapseTimeBetweenOperations > this.maxTimeBetweenOperation || this.currentClusterOfFetchRule == null)) {
            this.currentClusterOfFetchRule = this.getFeatureRule(cdoObject.eClass(), feature);
        }
    }

    @Override
    protected void doPostTraverseFeature(CDOObject cdoObject, EStructuralFeature feature, int index, Object object) {
        if (this.didFetch()) {
            this.currentClusterOfFetchRule.getFeatureInfo().activate(cdoObject.eClass(), feature);
        }
    }
}

