/*******************************************************************************
 * Copyright (c) 2016, 2017 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Grégoire Dupé (Mia-Software) - Bug 506320 - [Table] The table widget should provide the drag support
 *     Grégoire Dupe (Mia-Software) - Bug 516054 - [Table] The "drag event" does not contains the selection
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal;

import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;

public final class TableDragSourceListener implements DragSourceListener {

	private ISelection selection;
	private final ITableWidgetInternal tableWidgetController;

	public TableDragSourceListener(final ITableWidgetInternal tableWidgetController) {
		this.tableWidgetController = tableWidgetController;
	}

	public void dragStart(final DragSourceEvent event) {
		this.selection = this.tableWidgetController.getSelection();
	}

	public void dragSetData(final DragSourceEvent event) {
		if (LocalTransfer.getInstance().isSupportedType(event.dataType)) {
			if (this.selection instanceof IStructuredSelection) {
				event.data = this.selection;
			} else {
				event.doit = false;
			}
		}
	}

	public void dragFinished(final DragSourceEvent event) {
		this.selection = null;
	}
}
