/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.common;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.graphiti.examples.common.Messages;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;

public class FileService {
    public static void createEmfFileForDiagram(URI diagramResourceUri, final Diagram diagram) {
        TransactionalEditingDomain editingDomain = GraphitiUiInternal.getEmfService().createResourceSetAndEditingDomain();
        ResourceSet resourceSet = editingDomain.getResourceSet();
        final Resource resource = resourceSet.createResource(diagramResourceUri);
        CommandStack commandStack = editingDomain.getCommandStack();
        commandStack.execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                resource.setTrackingModification(true);
                resource.getContents().add((Object)diagram);
            }
        });
        FileService.save(editingDomain, Collections.<Resource, Map<?, ?>>emptyMap());
        editingDomain.dispose();
    }

    private static void save(TransactionalEditingDomain editingDomain, Map<Resource, Map<?, ?>> options) {
        FileService.saveInWorkspaceRunnable(editingDomain, options);
    }

    private static void saveInWorkspaceRunnable(final TransactionalEditingDomain editingDomain, final Map<Resource, Map<?, ?>> options) {
        final HashMap<URI, Throwable> failedSaves = new HashMap<URI, Throwable>();
        IWorkspaceRunnable wsRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        InternalTransaction parentTx;
                        if (editingDomain != null && (parentTx = ((TransactionalEditingDomainImpl)editingDomain).getActiveTransaction()) != null) {
                            do {
                                if (parentTx.isReadOnly()) continue;
                                throw new IllegalStateException("FileService.save() called from within a command (likely produces a deadlock)");
                            } while ((parentTx = ((TransactionalEditingDomainImpl)editingDomain).getActiveTransaction().getParent()) != null);
                        }
                        EList resources = editingDomain.getResourceSet().getResources();
                        Object[] resourcesArray = new Resource[resources.size()];
                        resourcesArray = (Resource[])resources.toArray(resourcesArray);
                        HashSet<Object> savedResources = new HashSet<Object>();
                        int i = 0;
                        while (i < resourcesArray.length) {
                            Object resource = resourcesArray[i];
                            if (resource.isModified()) {
                                try {
                                    resource.save((Map)options.get(resource));
                                    savedResources.add(resource);
                                }
                                catch (Throwable t) {
                                    failedSaves.put(resource.getURI(), t);
                                }
                            }
                            ++i;
                        }
                    }
                };
                try {
                    editingDomain.runExclusive(runnable);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                editingDomain.getCommandStack().flush();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wsRunnable, null);
            if (!failedSaves.isEmpty()) {
                throw new WrappedException(FileService.createMessage(failedSaves), (Exception)new RuntimeException());
            }
        }
        catch (CoreException e) {
            Throwable cause = e.getStatus().getException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e);
        }
    }

    private static String createMessage(Map<URI, Throwable> failedSaves) {
        StringBuilder buf = new StringBuilder(Messages.FileService_ErrorMessageStart);
        for (Map.Entry<URI, Throwable> entry : failedSaves.entrySet()) {
            buf.append(Messages.FileService_ErrorMessageUri).append(entry.getKey().toString()).append(Messages.FileService_ErrorMessageCause).append(FileService.getExceptionAsString(entry.getValue()));
        }
        return buf.toString();
    }

    private static String getExceptionAsString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        String result = stringWriter.toString();
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {}
        printWriter.close();
        return result;
    }
}

