/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;

public class Util {
    public static Object moveElementInList(List<Object> list, int targetIndex, int sourceIndex) {
        if (targetIndex >= list.size() || targetIndex < 0) {
            throw new IndexOutOfBoundsException("targetIndex=" + targetIndex + ", size=" + list.size());
        }
        if (sourceIndex >= list.size() || sourceIndex < 0) {
            throw new IndexOutOfBoundsException("sourceIndex=" + sourceIndex + ", size=" + list.size());
        }
        Object object = list.get(sourceIndex);
        if (targetIndex != sourceIndex) {
            list.remove(sourceIndex);
            list.add(targetIndex, object);
        }
        return object;
    }

    public static boolean equalsWithNull(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static EClass[] getAllClasses(IProject project, ResourceSet rSet) {
        EList resources = rSet.getResources();
        for (Resource resource : resources) {
            resource.unload();
        }
        rSet.getResources().retainAll((Collection)Collections.EMPTY_LIST);
        HashSet<EClass> eClasses = new HashSet<EClass>();
        IFolder folder = project.getFolder("src");
        IFolder folderDiagrams = project.getFolder("src/diagrams");
        if (folder.exists()) {
            ArrayList<IResource> membersList = new ArrayList<IResource>();
            try {
                membersList.addAll(Arrays.asList(folder.members()));
                membersList.addAll(Arrays.asList(folderDiagrams.members()));
            }
            catch (CoreException coreException) {
                return new EClass[0];
            }
            for (IResource resource : membersList) {
                URI uri;
                Resource fileResource;
                IFile file;
                if (!(resource instanceof IFile) || !"diagram".equals((file = (IFile)resource).getFileExtension()) && !file.getName().equals("Predefined.data") || (fileResource = rSet.getResource(uri = GraphitiUiInternal.getEmfService().getFileURI(file), true)) == null) continue;
                EList contents = fileResource.getContents();
                for (EObject object : contents) {
                    if (!(object instanceof EClass) || object instanceof PictogramElement) continue;
                    eClasses.add((EClass)object);
                }
            }
        }
        return eClasses.toArray(new EClass[eClasses.size()]);
    }
}

