/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.pgm.AbstractFetchCommand;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.SystemReader;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_cloneRepositoryIntoNewDir")
class Clone
extends AbstractFetchCommand
implements CloneCommand.Callback {
    @Option(name="--origin", aliases={"-o"}, metaVar="metaVar_remoteName", usage="usage_useNameInsteadOfOriginToTrackUpstream")
    private String remoteName = "origin";
    @Option(name="--branch", aliases={"-b"}, metaVar="metaVar_branchName", usage="usage_checkoutBranchAfterClone")
    private String branch;
    @Option(name="--no-checkout", aliases={"-n"}, usage="usage_noCheckoutAfterClone")
    private boolean noCheckout;
    @Option(name="--bare", usage="usage_bareClone")
    private boolean isBare;
    @Option(name="--quiet", usage="usage_quiet")
    private Boolean quiet;
    @Option(name="--recurse-submodules", usage="usage_recurseSubmodules")
    private boolean cloneSubmodules;
    @Argument(index=0, required=true, metaVar="metaVar_uriish")
    private String sourceUri;
    @Argument(index=1, metaVar="metaVar_directory")
    private String localName;

    Clone() {
    }

    @Override
    protected final boolean requiresRepository() {
        return false;
    }

    @Override
    protected void run() throws Exception {
        boolean msgs;
        File localNameF;
        if (this.localName != null && this.gitdir != null) {
            throw Clone.die(CLIText.get().conflictingUsageOf_git_dir_andArguments);
        }
        URIish uri = new URIish(this.sourceUri);
        if (this.localName == null) {
            try {
                this.localName = uri.getHumanishName();
                localNameF = new File(SystemReader.getInstance().getProperty("user.dir"), this.localName);
            }
            catch (IllegalArgumentException e) {
                throw Clone.die(MessageFormat.format(CLIText.get().cannotGuessLocalNameFrom, this.sourceUri));
            }
        } else {
            localNameF = new File(this.localName);
        }
        if (this.branch == null) {
            this.branch = "HEAD";
        }
        CloneCommand command = Git.cloneRepository();
        command.setURI(this.sourceUri).setRemote(this.remoteName).setBare(this.isBare).setNoCheckout(this.noCheckout).setBranch(this.branch).setCloneSubmodules(this.cloneSubmodules);
        command.setGitDir(this.gitdir == null ? null : new File(this.gitdir));
        command.setDirectory(localNameF);
        boolean bl = msgs = this.quiet == null || this.quiet == false;
        if (msgs) {
            command.setProgressMonitor((ProgressMonitor)new TextProgressMonitor((Writer)this.errw)).setCallback((CloneCommand.Callback)this);
            this.outw.println(MessageFormat.format(CLIText.get().cloningInto, this.localName));
            this.outw.flush();
        }
        try {
            this.db = command.call().getRepository();
            if (msgs && this.db.resolve("HEAD") == null) {
                this.outw.println(CLIText.get().clonedEmptyRepository);
            }
        }
        catch (InvalidRemoteException e) {
            throw Clone.die(MessageFormat.format(CLIText.get().doesNotExist, this.sourceUri));
        }
        finally {
            if (this.db != null) {
                this.db.close();
            }
        }
        if (msgs) {
            this.outw.println();
            this.outw.flush();
        }
    }

    public void initializedSubmodules(Collection<String> submodules) {
        try {
            for (String submodule : submodules) {
                this.outw.println(MessageFormat.format(CLIText.get().submoduleRegistered, submodule));
            }
            this.outw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void cloningSubmodule(String path) {
        try {
            this.outw.println(MessageFormat.format(CLIText.get().cloningInto, path));
            this.outw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void checkingOut(AnyObjectId commit, String path) {
        try {
            this.outw.println(MessageFormat.format(CLIText.get().checkingOut, path, commit.getName()));
            this.outw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

