/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.exportmodel;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.componentcore.util.EARVirtualComponent;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.flat.AbstractFlattenParticipant;
import org.eclipse.wst.common.componentcore.internal.flat.FlatVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class JEEHeirarchyExportParticipant
extends AbstractFlattenParticipant {
    public static final String JEE_VERSION = "org.eclipse.jst.j2ee.internal.deployables.export.eeVersion";
    public static String[] CHILDREN_EXTENSIONS = new String[]{".jar", ".zip", ".rar", ".war"};

    public boolean isChildModule(IVirtualComponent rootComponent, IVirtualReference reference, FlatVirtualComponent.FlatComponentTaskModel dataModel) {
        if (this.isJEEComponent(rootComponent) && this.isJEEComponent(reference.getReferencedComponent())) {
            String parentType = JavaEEProjectUtilities.getJ2EEComponentType(rootComponent);
            String childType = JavaEEProjectUtilities.getJ2EEComponentType(reference.getReferencedComponent());
            return this.isApprovedNesting(parentType, childType, reference.getReferencedComponent().isBinary());
        }
        return false;
    }

    private boolean isJEEComponent(IVirtualComponent component) {
        IVirtualComponent tmp = component.getComponent();
        return tmp instanceof J2EEModuleVirtualComponent || tmp instanceof J2EEModuleVirtualArchiveComponent || tmp instanceof EARVirtualComponent;
    }

    protected boolean isPossibleChild(String name) {
        int i = 0;
        while (i < CHILDREN_EXTENSIONS.length) {
            if (name.endsWith(CHILDREN_EXTENSIONS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isChildModule(IVirtualComponent rootComponent, FlatVirtualComponent.FlatComponentTaskModel dataModel, IFlatFile file) {
        if (this.isPossibleChild(file.getName())) {
            String path = null;
            IFile f = (IFile)file.getAdapter(IFile.class);
            if (f != null && f.exists()) {
                path = f.getFullPath().toString();
            } else {
                File f2 = (File)file.getAdapter(File.class);
                if (f2 != null && f2.exists()) {
                    path = f2.getAbsolutePath();
                }
            }
            if (path != null) {
                String parentType = JavaEEProjectUtilities.getJ2EEComponentType(rootComponent);
                String type = "lib/";
                IVirtualComponent dynamicComponent = ComponentCore.createArchiveComponent((IProject)rootComponent.getProject(), (String)(String.valueOf(type) + path), (IPath)file.getModuleRelativePath().makeAbsolute());
                String childType = JavaEEProjectUtilities.getJ2EEComponentType(dynamicComponent);
                return this.isApprovedNesting(parentType, childType, true);
            }
        }
        return false;
    }

    protected boolean isApprovedNesting(String parentType, String childType, boolean binary) {
        if (childType == null) {
            return false;
        }
        return !"jst.utility".equals(childType) || !binary;
    }
}

