/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.wizards.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.meta.model.data.DataType;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.wizards.NotResizableWizardDialog;
import org.eclipse.jwt.we.misc.wizards.model.CreateDatatypeWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class SelectDatatypeWizardPage
extends WizardPage {
    protected Combo typeCombo;
    protected Text valueField;
    protected Button addButton;
    protected Hashtable<String, DataType> typesTable = new Hashtable();
    protected IWorkbench workbench;
    protected ModifyListener validator = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            SelectDatatypeWizardPage.this.setPageComplete(SelectDatatypeWizardPage.this.validatePage());
        }
    };

    public SelectDatatypeWizardPage(String pageId, IWorkbench workbench) {
        super(pageId);
        this.workbench = workbench;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        Label typeLabel = new Label(composite, 131072);
        typeLabel.setText(String.valueOf(org.eclipse.jwt.meta.PluginProperties.model_DataType_type) + ":");
        this.typeCombo = new Combo(composite, 12);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.typeCombo.setLayoutData((Object)data);
        this.refreshDataTypes();
        this.addButton = new Button(composite, 8);
        this.addButton.setText(PluginProperties.wizards_AddDatatype_label);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateDatatypeWizard wizard = new CreateDatatypeWizard();
                wizard.init(PlatformUI.getWorkbench(), null);
                NotResizableWizardDialog dialog = new NotResizableWizardDialog(GeneralHelper.getActiveShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
                SelectDatatypeWizardPage.this.refreshDataTypes();
            }
        });
        Label valueLabel = new Label(composite, 131072);
        valueLabel.setText(String.valueOf(org.eclipse.jwt.meta.PluginProperties.model_Data_value_name) + ":");
        this.valueField = new Text(composite, 2048);
        GridData data2 = new GridData();
        data2.horizontalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        data2.horizontalSpan = 2;
        this.valueField.setLayoutData((Object)data2);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    public String getValue() {
        return this.valueField.getText();
    }

    public DataType getDataType() {
        return this.typesTable.get(this.typeCombo.getText());
    }

    protected boolean validatePage() {
        if (this.typeCombo.getText() == "") {
            this.setErrorMessage(null);
            return false;
        }
        return true;
    }

    private void refreshDataTypes() {
        WEEditor editor = GeneralHelper.getActiveInstance();
        Object obj = editor.getModel();
        if (obj instanceof Package) {
            this.collectDataTypes((Package)obj);
        }
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<String> en = this.typesTable.keys();
        while (en.hasMoreElements()) {
            names.add(en.nextElement());
        }
        Collections.sort(names, new CaseInsensitiveComparator());
        String[] comboIn = new String[this.typesTable.size()];
        names.toArray(comboIn);
        this.typeCombo.setItems(comboIn);
        this.typeCombo.addModifyListener(this.validator);
    }

    private void collectDataTypes(Package pack) {
        if (pack.getElements().size() != 0) {
            this.searchPackage(pack);
        }
        if (pack.getSubpackages().size() != 0) {
            EList subPack = pack.getSubpackages();
            int i = 0;
            while (i < subPack.size()) {
                this.collectDataTypes((Package)subPack.get(i));
                ++i;
            }
        }
    }

    private void searchPackage(Package pack) {
        EList elements = pack.getElements();
        int i = 0;
        while (i < elements.size()) {
            if (elements.get(i) instanceof DataType) {
                DataType data = (DataType)elements.get(i);
                this.typesTable.put(data.getName(), data);
            }
            ++i;
        }
    }

    class CaseInsensitiveComparator
    implements Comparator {
        CaseInsensitiveComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = o1.toString().toUpperCase();
            String s2 = o2.toString().toUpperCase();
            return s1.compareTo(s2);
        }
    }
}

