/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.ui.internal;

import java.util.ArrayList;
import java.util.List;

public class SearchTextHistory {
    private static final int MAX_HISTORY = 10;
    private List<String> history = new ArrayList<String>();
    private int index = 0;

    public void add(String text) {
        int found = -1;
        int size = this.history.size();
        int i = 0;
        while (i < size) {
            String s = this.history.get(i);
            if (s.equals(text)) {
                found = i;
                break;
            }
            ++i;
        }
        if (found == -1) {
            if (size >= 10) {
                this.history.remove(size - 1);
            }
            this.history.add(0, text);
        } else if (found != 0) {
            this.history.remove(found);
            this.history.add(0, text);
        }
        this.index = 0;
    }

    public String back() {
        if (this.canBack()) {
            String text = this.history.get(this.index);
            ++this.index;
            return text;
        }
        return null;
    }

    public String forward() {
        if (this.canForward()) {
            --this.index;
            String text = this.history.get(this.index);
            return text;
        }
        return null;
    }

    public boolean canForward() {
        return this.index > 0;
    }

    public boolean canBack() {
        return this.index < this.history.size();
    }

    public String current() {
        return this.history.size() == 0 ? null : this.history.get(0);
    }
}

