/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.ProjectSpecificLanguageServerWrapper;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.services.LanguageServer;

public class LanguageServiceAccessor {
    private static Map<WrapperEntryKey, List<ProjectSpecificLanguageServerWrapper>> projectServers = new HashMap<WrapperEntryKey, List<ProjectSpecificLanguageServerWrapper>>();
    private static Map<StreamConnectionProvider, LanguageServersRegistry.LanguageServerDefinition> connectionsInfo = new HashMap<StreamConnectionProvider, LanguageServersRegistry.LanguageServerDefinition>();

    private LanguageServiceAccessor() {
    }

    public static @Nullable LSPDocumentInfo getLSPDocumentInfoFor(@NonNull ITextViewer viewer, @Nullable Predicate<ServerCapabilities> capabilityRequest) {
        return LanguageServiceAccessor.getLSPDocumentInfoFor(viewer.getDocument(), capabilityRequest);
    }

    public static @Nullable LSPDocumentInfo getLSPDocumentInfoFor(@NonNull IDocument document, @Nullable Predicate<ServerCapabilities> capabilityRequest) {
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(document);
        if (buffer == null) {
            return null;
        }
        IPath location = buffer.getLocation();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(location);
        URI fileUri = null;
        if (file.exists()) {
            fileUri = LSPEclipseUtils.toUri((IResource)file);
            try {
                ProjectSpecificLanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapper(file, capabilityRequest, null);
                if (wrapper != null) {
                    wrapper.connect(file.getLocation(), document);
                    @Nullable LanguageServer server = wrapper.getServer();
                    if (server != null) {
                        return new LSPDocumentInfo(fileUri, document, wrapper, server);
                    }
                }
            }
            catch (Exception e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return null;
    }

    public static @Nullable LanguageServer getLanguageServer(@NonNull IFile file, Predicate<ServerCapabilities> request) throws IOException {
        ProjectSpecificLanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapper(file, request, null);
        if (wrapper != null) {
            wrapper.connect(file.getLocation(), null);
            return wrapper.getServer();
        }
        return null;
    }

    public static @Nullable LanguageServer getLanguageServer(@NonNull IFile file, Predicate<ServerCapabilities> request, @NonNull String serverId) throws IOException {
        ProjectSpecificLanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapper(file, request, serverId);
        if (wrapper != null) {
            wrapper.connect(file.getLocation(), null);
            return wrapper.getServer();
        }
        return null;
    }

    private static @Nullable ProjectSpecificLanguageServerWrapper getLSWrapper(@NonNull IFile file, @Nullable Predicate<ServerCapabilities> request, @Nullable String serverId) throws IOException {
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        IContentType[] fileContentTypes = null;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream contents = file.getContents();){
                fileContentTypes = Platform.getContentTypeManager().findContentTypesFor(contents, file.getName());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError(e);
            return null;
        }
        ProjectSpecificLanguageServerWrapper wrapper = LanguageServiceAccessor.getMatchingStartedWrapper(project, fileContentTypes, request, serverId);
        if (wrapper != null) {
            return wrapper;
        }
        IContentType[] iContentTypeArray = fileContentTypes;
        int n = fileContentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            if (contentType != null) {
                for (LanguageServersRegistry.LanguageServerDefinition serverDefinition : LanguageServersRegistry.getInstance().findProviderFor(contentType)) {
                    if (serverDefinition == null || serverId != null && !serverDefinition.getId().equals(serverId)) continue;
                    wrapper = LanguageServiceAccessor.getLSWrapperForConnection(project, contentType, serverDefinition);
                    if (request != null && wrapper.getServerCapabilities() != null && !request.test(wrapper.getServerCapabilities())) continue;
                    return wrapper;
                }
            }
            ++n2;
        }
        return null;
    }

    public static ProjectSpecificLanguageServerWrapper getLSWrapperForConnection(@NonNull IProject project, @NonNull IContentType contentType, @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition) throws IOException {
        WrapperEntryKey key;
        ProjectSpecificLanguageServerWrapper wrapper = null;
        for (ProjectSpecificLanguageServerWrapper startedWrapper : LanguageServiceAccessor.getStartedLSWarppers(project)) {
            if (!startedWrapper.serverDefinition.equals(serverDefinition)) continue;
            wrapper = startedWrapper;
            break;
        }
        if (wrapper == null) {
            wrapper = new ProjectSpecificLanguageServerWrapper(project, serverDefinition);
            wrapper.start();
        }
        if (!projectServers.containsKey(key = new WrapperEntryKey(project, contentType))) {
            projectServers.put(key, new ArrayList());
        }
        projectServers.get(key).add(wrapper);
        return wrapper;
    }

    private static @NonNull List<ProjectSpecificLanguageServerWrapper> getStartedLSWarppers(@NonNull IProject project) {
        return projectServers.values().stream().flatMap(Collection::stream).filter(wrapper -> wrapper.project.equals((Object)project)).collect(Collectors.toList());
    }

    private static ProjectSpecificLanguageServerWrapper getMatchingStartedWrapper(IProject project, IContentType[] fileContentTypes, Predicate<ServerCapabilities> request, @Nullable String serverId) {
        IContentType[] iContentTypeArray = fileContentTypes;
        int n = fileContentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            WrapperEntryKey key = new WrapperEntryKey(project, contentType);
            if (!projectServers.containsKey(key)) {
                projectServers.put(key, new ArrayList());
            }
            for (ProjectSpecificLanguageServerWrapper aWrapper : projectServers.get(key)) {
                if (aWrapper == null || serverId != null && !aWrapper.serverDefinition.getId().equals(serverId) || request != null && aWrapper.getServerCapabilities() != null && !request.test(aWrapper.getServerCapabilities())) continue;
                return aWrapper;
            }
            ++n2;
        }
        return null;
    }

    public static @NonNull List<LSPServerInfo> getLSPServerInfos(@NonNull IProject project, Predicate<ServerCapabilities> request) {
        ArrayList<LSPServerInfo> serverInfos = new ArrayList<LSPServerInfo>();
        for (Map.Entry<WrapperEntryKey, List<ProjectSpecificLanguageServerWrapper>> entry : projectServers.entrySet()) {
            WrapperEntryKey wrapperEntryKey = entry.getKey();
            if (!project.equals((Object)wrapperEntryKey.project)) continue;
            for (ProjectSpecificLanguageServerWrapper wrapper : entry.getValue()) {
                @Nullable LanguageServer server = wrapper.getServer();
                if (server == null || request != null && wrapper.getServerCapabilities() != null && !request.test(wrapper.getServerCapabilities())) continue;
                serverInfos.add(new LSPServerInfo(project, server, wrapper.getServerCapabilities()));
            }
        }
        return serverInfos;
    }

    protected static LanguageServersRegistry.LanguageServerDefinition getInfo(@NonNull StreamConnectionProvider provider) {
        return connectionsInfo.get(provider);
    }

    public static class LSPDocumentInfo {
        private final @NonNull URI fileUri;
        private final @NonNull IDocument document;
        private final @NonNull ProjectSpecificLanguageServerWrapper wrapper;
        private final @NonNull LanguageServer server;

        private LSPDocumentInfo(@NonNull URI fileUri, @NonNull IDocument document, @NonNull ProjectSpecificLanguageServerWrapper wrapper, @NonNull LanguageServer server) {
            this.fileUri = fileUri;
            this.document = document;
            this.wrapper = wrapper;
            this.server = server;
        }

        public @NonNull IDocument getDocument() {
            return this.document;
        }

        public @NonNull URI getFileUri() {
            return this.fileUri;
        }

        public @NonNull LanguageServer getLanguageClient() {
            return this.server;
        }

        public @Nullable ServerCapabilities getCapabilites() {
            return this.wrapper.getServerCapabilities();
        }

        public boolean isActive() {
            return this.wrapper.isActive();
        }
    }

    public static class LSPServerInfo {
        private final @NonNull IProject project;
        private final @Nullable ServerCapabilities capabilities;
        private final @NonNull LanguageServer languageServer;

        private LSPServerInfo(@NonNull IProject project, @NonNull LanguageServer languageServer, @Nullable ServerCapabilities capabilities) {
            this.project = project;
            this.languageServer = languageServer;
            this.capabilities = capabilities;
        }

        public @NonNull IProject getProject() {
            return this.project;
        }

        public @NonNull LanguageServer getLanguageServer() {
            return this.languageServer;
        }

        public @Nullable ServerCapabilities getCapabilites() {
            return this.capabilities;
        }
    }

    static class WrapperEntryKey {
        final IProject project;
        final IContentType contentType;

        public WrapperEntryKey(IProject project, IContentType contentType) {
            this.project = project;
            this.contentType = contentType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.contentType == null ? 0 : this.contentType.hashCode());
            result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WrapperEntryKey other = (WrapperEntryKey)obj;
            if (this.contentType == null ? other.contentType != null : !this.contentType.equals(other.contentType)) {
                return false;
            }
            return !(this.project == null ? other.project != null : !this.project.equals((Object)other.project));
        }
    }
}

