/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.symbols;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.symbols.LSPSymbolInFileDialog;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPSymbolInFileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (part instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)part;
            LanguageServiceAccessor.LSPDocumentInfo info = LanguageServiceAccessor.getLSPDocumentInfoFor(LSPEclipseUtils.getDocument(textEditor), capabilities -> Boolean.TRUE.equals(capabilities.getDocumentSymbolProvider()));
            if (info == null) {
                return null;
            }
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            DocumentSymbolParams params = new DocumentSymbolParams(new TextDocumentIdentifier(info.getFileUri().toString()));
            CompletableFuture symbols = info.getLanguageClient().getTextDocumentService().documentSymbol(params);
            symbols.thenAccept(t -> shell.getDisplay().asyncExec(() -> {
                LSPSymbolInFileDialog dialog = new LSPSymbolInFileDialog(shell, textEditor, (List<? extends SymbolInformation>)t);
                dialog.open();
            }));
        }
        return null;
    }
}

