/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.om.OMPlatform;

public abstract class RunnableWithName
implements Runnable {
    private static final boolean DISABLE_RUNNABLE_NAMES = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.util.concurrent.DISABLE_RUNNABLE_NAMES");

    public final void run() {
        if (DISABLE_RUNNABLE_NAMES) {
            this.doRun();
            return;
        }
        Thread thread = null;
        String oldName = null;
        String name = this.getName();
        if (!StringUtil.isEmpty(name)) {
            thread = Thread.currentThread();
            oldName = thread.getName();
            if (name.equals(oldName)) {
                thread = null;
                oldName = null;
            } else {
                thread.setName(name);
            }
        }
        try {
            this.doRun();
        }
        finally {
            if (thread != null) {
                thread.setName(oldName);
            }
        }
    }

    public abstract String getName();

    protected abstract void doRun();
}

