/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.lifecycle;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleException;

public class ShareableLifecycle
extends Lifecycle {
    AtomicInteger refCount;

    public ShareableLifecycle() {
        this(true);
    }

    public ShareableLifecycle(boolean shared) {
        if (shared) {
            this.refCount = new AtomicInteger();
        }
    }

    void internalActivate() throws LifecycleException {
        if (this.refCount == null || this.refCount.getAndIncrement() == 0) {
            super.internalActivate();
        }
    }

    Exception internalDeactivate() {
        if (this.refCount == null || this.refCount.decrementAndGet() == 0) {
            return super.internalDeactivate();
        }
        return null;
    }
}

