/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.oclinjunit;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGClass;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNamedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPackage;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.generator.LocalContext;
import org.eclipse.ocl.examples.codegen.java.ImportUtils;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.java.JavaGlobalContext;
import org.eclipse.ocl.examples.codegen.java.JavaLocalContext;
import org.eclipse.ocl.examples.codegen.oclinjunit.JUnitAS2CGVisitor;
import org.eclipse.ocl.examples.codegen.oclinjunit.JUnitCG2JavaClassVisitor;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.complete.CompleteEnvironmentInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class JUnitCodeGenerator
extends JavaCodeGenerator {
    protected final @NonNull JavaGlobalContext<@NonNull JUnitCodeGenerator> globalContext = new JavaGlobalContext<JUnitCodeGenerator>(this);
    protected final @NonNull CodeGenAnalyzer cgAnalyzer;

    public static @NonNull String generateClassFile(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull ExpressionInOCL query, @NonNull String packageName, @NonNull String className) {
        CompleteEnvironmentInternal completeEnvironment = environmentFactory.getMetamodelManager().getCompleteEnvironment();
        boolean savedIsCodeGenerator = completeEnvironment.isCodeGeneration();
        try {
            completeEnvironment.setCodeGeneration(true);
            JUnitCodeGenerator expressionInOCL2Class = new JUnitCodeGenerator(environmentFactory, true);
            String string = expressionInOCL2Class.generate(query, packageName, className);
            return string;
        }
        finally {
            completeEnvironment.setCodeGeneration(savedIsCodeGenerator);
        }
    }

    protected JUnitCodeGenerator(@NonNull EnvironmentFactoryInternal environmentFactory, boolean useNullAnnotations) {
        super(environmentFactory);
        this.getOptions().setUseNullAnnotations(useNullAnnotations);
        this.cgAnalyzer = new CodeGenAnalyzer(this);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull CGPackage createCGPackage(@NonNull ExpressionInOCL expInOcl, @NonNull String packageName, @NonNull String className) {
        CGPackage cgPackage = CGModelFactory.eINSTANCE.createCGPackage();
        cgPackage.setName(packageName);
        CGClass cgClass = CGModelFactory.eINSTANCE.createCGClass();
        cgClass.setName(className);
        cgPackage.getClasses().add(cgClass);
        Variable contextVariable = expInOcl.getOwnedContext();
        if (contextVariable != null) {
            contextVariable.setIsRequired(false);
        }
        JUnitAS2CGVisitor as2cgVisitor = new JUnitAS2CGVisitor(this.cgAnalyzer);
        CGValuedElement cgBody = (CGValuedElement)ClassUtil.nonNullState((Object)((CGNamedElement)expInOcl.accept((Visitor)as2cgVisitor)));
        CGLibraryOperation cgOperation = CGModelFactory.eINSTANCE.createCGLibraryOperation();
        List<CGParameter> cgParameters = cgOperation.getParameters();
        @NonNull LocalContext localContext = this.globalContext.getLocalContext(cgOperation);
        if (localContext != null) {
            Object typeIdParameter;
            CGParameter executorParameter = ((JavaLocalContext)localContext).createExecutorParameter();
            if (executorParameter != null) {
                cgParameters.add(executorParameter);
            }
            if ((typeIdParameter = ((JavaLocalContext)localContext).createTypeIdParameter()) != null) {
                cgParameters.add((CGParameter)typeIdParameter);
            }
        }
        if (contextVariable != null) {
            CGParameter cgContext = as2cgVisitor.getParameter(contextVariable, null);
            cgParameters.add(cgContext);
        }
        for (Variable parameterVariable : expInOcl.getOwnedParameters()) {
            CGParameter cgParameter = as2cgVisitor.getParameter(parameterVariable, null);
            cgParameters.add(cgParameter);
        }
        cgOperation.setAst((Element)expInOcl);
        Type type = expInOcl.getType();
        assert (type != null);
        TypeId asTypeId = PivotUtilInternal.getBehavioralType((Type)type).getTypeId();
        cgOperation.setTypeId(this.cgAnalyzer.getTypeId(asTypeId));
        cgOperation.setName(this.globalContext.getEvaluateName());
        cgOperation.setBody(cgBody);
        cgClass.getOperations().add(cgOperation);
        return cgPackage;
    }

    protected @NonNull String generate(@NonNull ExpressionInOCL expInOcl, @NonNull String packageName, @NonNull String className) {
        CGPackage cgPackage = this.createCGPackage(expInOcl, packageName, className);
        this.optimize(cgPackage);
        List<@NonNull CGValuedElement> sortedGlobals = this.prepareGlobals();
        JUnitCG2JavaClassVisitor cg2JavaClassVisitor = new JUnitCG2JavaClassVisitor(this, expInOcl, sortedGlobals);
        cg2JavaClassVisitor.safeVisit(cgPackage);
        Set<String> allImports = cg2JavaClassVisitor.getAllImports();
        Map<@NonNull String, @Nullable String> long2ShortImportNames = ImportUtils.getLong2ShortImportNames(allImports);
        return ImportUtils.resolveImports(cg2JavaClassVisitor.toString(), long2ShortImportNames, false);
    }

    @Override
    public @NonNull CodeGenAnalyzer getAnalyzer() {
        return this.cgAnalyzer;
    }

    @Override
    public @NonNull JavaGlobalContext<@NonNull JUnitCodeGenerator> getGlobalContext() {
        return this.globalContext;
    }
}

