/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.validity.locator;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ocl.examples.emf.validation.validity.ResultConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.locator.ConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.ui.locator.ConstraintUILocator;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityView;
import org.eclipse.ocl.examples.validity.locator.PivotConstraintLocator;
import org.eclipse.ocl.examples.xtext.console.messages.ConsoleMessages;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class PivotUIConstraintLocator
extends PivotConstraintLocator
implements ConstraintUILocator {
    public static @NonNull PivotUIConstraintLocator INSTANCE = new PivotUIConstraintLocator();

    public static @NonNull IStatus createStatus(Throwable e, String messageTemplate, Object ... bindings) {
        String message = StringUtil.bind((String)messageTemplate, (Object[])bindings);
        return new Status(4, "org.eclipse.ocl.examples.validity", 0, message, e);
    }

    public boolean debug(@NonNull ResultConstrainingNode resultConstrainingNode, @NonNull ValidityView validityView, @NonNull IProgressMonitor monitor) throws CoreException {
        ExpressionInOCL query;
        ValidatableNode validatableNode = resultConstrainingNode.getResultValidatableNode().getParent();
        assert (validatableNode != null);
        EObject constrainedObject = validatableNode.getConstrainedObject();
        Resource eResource = constrainedObject.eResource();
        if (eResource == null) {
            return false;
        }
        EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.getEnvironmentFactory((Resource)eResource);
        PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        Constraint asConstraint = null;
        Object constrainingObject = resultConstrainingNode.getParent().getConstrainingObject();
        if (constrainingObject instanceof Constraint) {
            asConstraint = (Constraint)constrainingObject;
        }
        if (asConstraint == null) {
            IStatus status = PivotUIConstraintLocator.createStatus(null, PivotMessagesInternal.MissingSpecification_ERROR_, NameUtil.qualifiedNameFor((Object)asConstraint), "constraint");
            throw new CoreException(status);
        }
        LanguageExpression specification = asConstraint.getOwnedSpecification();
        if (specification == null) {
            IStatus status = PivotUIConstraintLocator.createStatus(null, PivotMessagesInternal.MissingSpecificationBody_ERROR_, NameUtil.qualifiedNameFor((Object)asConstraint), "constraint");
            throw new CoreException(status);
        }
        try {
            query = metamodelManager.parseSpecification(specification);
        }
        catch (ParserException e) {
            IStatus status = PivotUIConstraintLocator.createStatus(e, PivotMessagesInternal.InvalidSpecificationBody_ERROR_, NameUtil.qualifiedNameFor((Object)asConstraint), "constraint");
            throw new CoreException(status);
        }
        ValidatableNode parent = resultConstrainingNode.getResultValidatableNode().getParent();
        if (parent == null) {
            return false;
        }
        EObject eObject = parent.getConstrainedObject();
        Shell shell = validityView.getSite().getShell();
        if (shell == null) {
            return false;
        }
        DebugStarter runnable = new DebugStarter(shell, environmentFactory, eObject, query);
        runnable.run(monitor);
        return runnable.getLaunch() != null;
    }

    @Override
    public @NonNull ConstraintLocator getInstance() {
        return INSTANCE;
    }

    protected static class DebugStarter
    implements IRunnableWithProgress {
        protected final @NonNull Shell shell;
        protected final @NonNull EnvironmentFactoryInternal environmentFactory;
        protected final @Nullable EObject contextObject;
        protected final @NonNull ExpressionInOCL constraint;
        private @Nullable ILaunch launch = null;

        public DebugStarter(@NonNull Shell shell, @NonNull EnvironmentFactoryInternal environmentFactory, @Nullable EObject contextObject, @NonNull ExpressionInOCL constraint) {
            this.shell = shell;
            this.environmentFactory = environmentFactory;
            this.contextObject = contextObject;
            this.constraint = constraint;
        }

        public ILaunch getLaunch() {
            return this.launch;
        }

        protected ILaunch launchDebugger(IProgressMonitor monitor, @Nullable EObject contextObject, @NonNull ExpressionInOCL expressionInOCL) throws CoreException {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.ocl.examples.debug.launching.OCLLaunchConfigurationDelegate");
            ILaunchConfigurationWorkingCopy launchConfiguration = launchConfigurationType.newInstance(null, "test");
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("expressionObject", expressionInOCL);
            attributes.put("contextObject", contextObject);
            launchConfiguration.setAttributes(attributes);
            return launchConfiguration.launch("debug", monitor);
        }

        protected void openError(final String message, final @NonNull Exception e) {
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Status status = new Status(4, "org.eclipse.ocl.examples.xtext.console", e.getLocalizedMessage(), (Throwable)e);
                    ErrorDialog.openError((Shell)shell, (String)ConsoleMessages.Debug_Starter, (String)message, (IStatus)status);
                }
            });
        }

        public void run(IProgressMonitor monitor) {
            String expression = this.constraint.toString();
            monitor.beginTask(NLS.bind((String)ConsoleMessages.Debug_Starter, (Object)expression), 1);
            try {
                monitor.subTask(ConsoleMessages.Debug_ProgressLoad);
                try {
                    this.launch = this.launchDebugger(monitor, this.contextObject, this.constraint);
                }
                catch (CoreException e) {
                    this.openError(ConsoleMessages.Debug_FailLaunch, (Exception)((Object)e));
                }
                monitor.worked(1);
            }
            finally {
                monitor.done();
            }
        }
    }
}

