/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.util.core.internal.exported;

import com.ibm.icu.lang.UCharacter;
import org.eclipse.papyrus.emf.facet.util.core.internal.Messages;

public final class StringUtils {
    public static final String ELLIPSIS = Messages.StringUtils_ellipsis;
    private static final int TRUNCATE_AFTER = 150;

    private StringUtils() {
    }

    public static String firstLetterToLowerCase(String source) {
        String result = source.length() == 0 ? source : (source.length() == 1 ? source.toLowerCase() : String.valueOf(source.substring(0, 1).toLowerCase()) + source.substring(1));
        return result;
    }

    public static String firstLetterToUpperCase(String source) {
        String result = source.length() == 0 ? source : (source.length() == 1 ? source.toUpperCase() : String.valueOf(source.substring(0, 1).toUpperCase()) + source.substring(1));
        return result;
    }

    public static String truncateBeforeNewline(String str) {
        int endIndex = str.indexOf(13);
        if (endIndex == -1) {
            endIndex = str.indexOf(10);
        }
        if (endIndex != -1 && endIndex <= 150) {
            return String.valueOf(str.substring(0, endIndex)) + ELLIPSIS;
        }
        if (endIndex == -1) {
            endIndex = str.length();
        }
        if (endIndex > 150) {
            return String.valueOf(str.substring(0, 75)) + ELLIPSIS + str.substring(str.length() - 75, endIndex);
        }
        return str;
    }

    public static String inferJavaClassName(String name) {
        String upperName = StringUtils.firstLetterToUpperCase(name.trim());
        StringBuilder javaName = new StringBuilder();
        boolean space = false;
        int i = 0;
        while (i < upperName.length()) {
            char c = upperName.charAt(i);
            if (c == ' ') {
                space = true;
            } else if (space) {
                javaName.append(UCharacter.toUpperCase((int)c));
                space = false;
            } else {
                javaName.append(c);
            }
            ++i;
        }
        return javaName.toString();
    }
}

