/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.pluginexplorer;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.papyrus.infra.core.pluginexplorer.Plugin;
import org.eclipse.papyrus.infra.core.pluginexplorer.PluginEntry;
import org.eclipse.papyrus.infra.core.pluginexplorer.PluginsContentLabelProvider;
import org.eclipse.papyrus.infra.core.pluginexplorer.PluginsContentProvider;
import org.eclipse.papyrus.infra.core.pluginexplorer.PluginsContentSelectionValidator;
import org.eclipse.swt.events.SegmentEvent;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class PluginsContentDialog
extends Dialog {
    private static final int SIZE_WIDTH = 400;
    private static final int SIZE_HEIGHT = 300;
    private PluginsContentSelectionValidator validator;
    private String title;
    private String message;
    private Plugin[] plugins;
    private TreeViewer tree;
    private Text field;
    private Object selection;

    public Object getSelection() {
        return this.selection;
    }

    public PluginsContentDialog(Shell parentShell, PluginsContentSelectionValidator validator, String title, String message) {
        super(parentShell);
        this.validator = validator;
        this.title = title;
        this.message = message;
        this.plugins = Plugin.getLoadedPlugins();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 68);
        label.setText(this.message);
        label.setLayoutData((Object)new GridData(768));
        this.field = new Text(composite, 2052);
        this.field.setLayoutData((Object)new GridData(768));
        this.field.addSegmentListener(new SegmentListener(){

            public void getSegments(SegmentEvent event) {
                if (PluginsContentDialog.this.tree != null) {
                    PluginsContentDialog.this.tree.setContentProvider((IContentProvider)new PluginsContentProvider(PluginsContentDialog.this.plugins, PluginsContentDialog.this.field.getText()));
                }
            }
        });
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(1808));
        inner.setLayout((Layout)new FillLayout());
        this.tree = new TreeViewer(inner, 2816);
        this.tree.setLabelProvider((IBaseLabelProvider)new PluginsContentLabelProvider());
        this.tree.setSorter(this.getViewerSorter());
        this.tree.setContentProvider((IContentProvider)new PluginsContentProvider(this.plugins, null));
        this.tree.setInput(PluginsContentProvider.treeRoot);
        this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                PluginsContentDialog.this.selection = s.getFirstElement();
                PluginsContentDialog.this.resetValidity();
            }
        });
        PluginsContentDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control composite = super.createButtonBar(parent);
        this.resetValidity();
        return composite;
    }

    private void resetValidity() {
        if (this.selection == null) {
            this.getButton(0).setEnabled(false);
            return;
        }
        if (this.validator == null) {
            this.getButton(0).setEnabled(true);
            return;
        }
        boolean valid = false;
        if (this.selection instanceof Plugin) {
            valid = this.validator.isValid((Plugin)this.selection);
        } else if (this.selection instanceof PluginEntry) {
            valid = this.validator.isValid((PluginEntry)this.selection);
        }
        this.getButton(0).setEnabled(valid);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setSize(400, 300);
        Point size = shell.getParent().getShell().getSize();
        shell.setLocation((size.x - 400) / 2, (size.y - 300) / 2);
        shell.setText(this.title);
    }

    private ViewerSorter getViewerSorter() {
        return new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof Bundle) {
                    Bundle b1 = (Bundle)e1;
                    Bundle b2 = (Bundle)e2;
                    return b1.getSymbolicName().compareTo(b2.getSymbolicName());
                }
                if (e1 instanceof File) {
                    File f1 = (File)e1;
                    File f2 = (File)e2;
                    return f1.getName().compareTo(f2.getName());
                }
                return super.compare(viewer, e1, e2);
            }
        };
    }
}

