/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.helper;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.gmfdiag.common.AbstractPapyrusGmfCreateDiagramCommandHandler;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramPrototype;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.gmfdiag.representation.RepresentationPackage;
import org.eclipse.papyrus.infra.viewpoints.policy.IViewTypeHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class GMFDiagramViewTypeHelper
implements IViewTypeHelper {
    private Map<PapyrusDiagram, DiagramPrototype> cache;

    public boolean isSupported(EClass type) {
        return EcoreUtil.equals((EObject)type, (EObject)RepresentationPackage.eINSTANCE.getPapyrusDiagram());
    }

    public boolean isSupported(EObject view) {
        return view instanceof Diagram;
    }

    public ViewPrototype getPrototypeFor(PapyrusRepresentationKind kind) {
        AbstractPapyrusGmfCreateDiagramCommandHandler command;
        if (!(kind instanceof PapyrusDiagram)) {
            return null;
        }
        PapyrusDiagram diagramKind = (PapyrusDiagram)kind;
        if (this.cache == null) {
            this.cache = new HashMap<PapyrusDiagram, DiagramPrototype>();
        }
        if (this.cache.containsKey(diagramKind)) {
            return this.cache.get(diagramKind);
        }
        String language = diagramKind.getLanguage().getId();
        try {
            Class creationCommandClass = diagramKind.getCreationCommandClass();
            command = (AbstractPapyrusGmfCreateDiagramCommandHandler)((Object)creationCommandClass.newInstance());
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
            return null;
        }
        DiagramPrototype proto = new DiagramPrototype(diagramKind, language, command);
        this.cache.put(diagramKind, proto);
        return proto;
    }

    public ViewPrototype getPrototypeOf(EObject view) {
        if (!this.isSupported(view)) {
            return null;
        }
        return DiagramUtils.getPrototype((Diagram)view);
    }
}

