/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.locator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.papyrus.uml.diagram.common.locator.AdvancedBorderItemLocator;

public class ActivityParameterNodePositionLocator
extends AdvancedBorderItemLocator
implements IBorderItemLocator {
    public static final int EXTRA_BORDER_DEFAULT_OFFSET = 8;
    public static final int DEFAULT_PIN_SIZE = 16;
    protected int borderItemOffset = 10;

    public ActivityParameterNodePositionLocator(IFigure parentFigure) {
        super(parentFigure);
    }

    public ActivityParameterNodePositionLocator(IFigure borderItem, IFigure parentFigure, Rectangle constraint) {
        super(borderItem, parentFigure, constraint);
    }

    public ActivityParameterNodePositionLocator(IFigure parentFigure, int preferredSide) {
        super(parentFigure, preferredSide);
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        if (realLocation.width < 16) {
            realLocation.setWidth(16);
        } else if (realLocation.height < 16) {
            realLocation.setHeight(16);
        }
        int side = ActivityParameterNodePositionLocator.findClosestSideOfParent(proposedLocation, this.getParentBorder());
        Point newTopLeft = this.locateOnBorder(realLocation.getTopLeft(), side, 0, borderItem);
        realLocation.setLocation(newTopLeft);
        return realLocation;
    }

    public static int findClosestSideOfParent(Rectangle proposedLocation, Rectangle parentBorder) {
        int side = BorderItemLocator.findClosestSideOfParent((Rectangle)proposedLocation, (Rectangle)parentBorder);
        if (side == 1) {
            Point parentCenter = parentBorder.getCenter();
            Point childCenter = proposedLocation.getCenter();
            if (childCenter.x < parentCenter.x) {
                return 8;
            }
            return 16;
        }
        return side;
    }

    protected Point locateOnParent(Point suggestedLocation, int suggestedSide, IFigure borderItem) {
        Rectangle parent = this.getParentBorder();
        Dimension borderItemSize = borderItem.getSize();
        int newX = suggestedLocation.x;
        int newY = suggestedLocation.y;
        switch (suggestedSide) {
            case 1: {
                int northY = parent.y() - borderItemSize.height / 2;
                if (suggestedLocation.y == northY) break;
                newY = northY;
                break;
            }
            case 4: {
                int southY = parent.bottom() - borderItemSize.height / 2;
                if (suggestedLocation.y == southY) break;
                newY = southY;
                break;
            }
            case 16: {
                int eastX = parent.right() - borderItemSize.width / 2;
                if (suggestedLocation.x == eastX) break;
                newX = eastX;
                break;
            }
            default: {
                int westX = parent.x() - borderItemSize.width / 2;
                if (suggestedLocation.x == westX) break;
                newX = westX;
            }
        }
        switch (suggestedSide) {
            case 1: 
            case 4: {
                if (suggestedLocation.x < parent.x() + 8) {
                    newX = parent.x() + 8;
                    break;
                }
                if (suggestedLocation.x + borderItemSize.width <= parent.getBottomRight().x - 8) break;
                newX = parent.getBottomRight().x - 8 - borderItemSize.width;
                break;
            }
            default: {
                if (suggestedLocation.y < parent.y() + 8) {
                    newY = parent.y() + 8;
                    break;
                }
                if (suggestedLocation.y + borderItemSize.height <= parent.getBottomLeft().y - 8) break;
                newY = parent.getBottomLeft().y - 8 - borderItemSize.height;
            }
        }
        return new Point(newX, newY);
    }

    public void relocate(IFigure borderItem) {
        Dimension size = this.getSize(borderItem);
        Rectangle rectSuggested = this.getConstraint().getCopy();
        if (rectSuggested.getTopLeft().x == 0 && rectSuggested.getTopLeft().y == 0) {
            rectSuggested.setLocation(this.getPreferredLocation(borderItem));
        } else {
            rectSuggested.setLocation(rectSuggested.getLocation().translate(this.getParentBorder().getTopLeft()));
        }
        rectSuggested.setSize(size);
        Rectangle validLocation = this.getValidLocation(rectSuggested, borderItem);
        borderItem.setBounds(validLocation);
        this.setCurrentSideOfParent(ActivityParameterNodePositionLocator.findClosestSideOfParent(borderItem.getBounds(), this.getParentBorder()));
    }

    protected Point getPreferredLocation(int side, IFigure borderItem) {
        return super.getPreferredLocation(side, borderItem);
    }

    protected Point locateOnBorder(Point suggestedLocation, int suggestedSide, int circuitCount, IFigure borderItem) {
        return super.locateOnBorder(suggestedLocation, suggestedSide, circuitCount, borderItem);
    }

    public Rectangle getPreferredLocation(Rectangle proposedLocation) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        Rectangle parentRec = this.getParentFigure().getBounds().getCopy();
        int xMin = parentRec.x + this.borderItemOffset;
        int xMax = parentRec.x + parentRec.width - this.borderItemOffset;
        int yMin = parentRec.y + this.borderItemOffset;
        int yMax = parentRec.y + parentRec.height - this.borderItemOffset;
        if (realLocation.x < xMin) {
            realLocation.x = xMin;
        }
        if (realLocation.x > xMax) {
            realLocation.x = xMax;
        }
        if (realLocation.y < yMin) {
            realLocation.y = yMin;
        }
        if (realLocation.y > yMax) {
            realLocation.y = yMax;
        }
        if (realLocation.y != yMin && realLocation.y != yMax && realLocation.x != xMin && realLocation.x != xMax) {
            realLocation.x = realLocation.x <= xMin + parentRec.width / 2 ? xMin : xMax;
        }
        return realLocation;
    }
}

