/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.interactionoverview.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.uml.diagram.activity.edit.part.CustomActivityActivityContentCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.communication.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.interactionoverview.Activator;
import org.eclipse.papyrus.uml.diagram.interactionoverview.edit.part.InteractionOverviewDiagramEditPart;
import org.eclipse.papyrus.uml.diagram.interactionoverview.figures.InteractionWithSnapshotFigure;
import org.eclipse.papyrus.uml.diagram.interactionoverview.part.Messages;
import org.eclipse.papyrus.uml.diagram.interactionoverview.provider.DiagramContentProvider;
import org.eclipse.papyrus.uml.diagram.interactionoverview.utils.CallBehaviorUtil;
import org.eclipse.papyrus.uml.diagram.interactionoverview.utils.CreateDiagramImage;
import org.eclipse.papyrus.uml.diagram.interactionoverview.utils.URIUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallBehaviorAction;
import org.eclipse.uml2.uml.Interaction;

public class CreateSnapshotForInteractionFromViewDescriptorCommand
extends AbstractTransactionalCommand {
    protected static final String ORG_ECLIPSE_PAPYRUS_UML_DIAGRAM_TIMING = "org.eclipse.papyrus.uml.diagram.timing";
    protected static final String PAPYRUS_UML_TIMING_DIAGRAM = "PapyrusUMLTimingDiagram";
    protected ICommand createElementCommand;
    protected GraphicalEditPart host;

    public CreateSnapshotForInteractionFromViewDescriptorCommand(TransactionalEditingDomain editingDomain, ICommand createElementCommand, GraphicalEditPart host) {
        super(editingDomain, Messages.CreateSnapshotForInteractionFromViewDescriptorCommand_CreateSnapshotForRefresh, null);
        this.createElementCommand = createElementCommand;
        this.host = host;
    }

    public boolean canExecute() {
        return true;
    }

    public static CreateSnapshotForInteractionFromViewDescriptorCommand create(ICommand createElementCommand, GraphicalEditPart host) {
        return new CreateSnapshotForInteractionFromViewDescriptorCommand(((AbstractEMFOperation)createElementCommand).getEditingDomain(), createElementCommand, host);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View callBehaviorActionView = this.getViewFromCommandResult(this.createElementCommand);
        Diagram diagram = null;
        if (this.host instanceof CustomActivityActivityContentCompartmentEditPart) {
            CallBehaviorAction callBehaviorAction = (CallBehaviorAction)callBehaviorActionView.getElement();
            Behavior behavior = callBehaviorAction.getBehavior();
            diagram = this.findSequenceDiagram((Interaction)behavior);
            ResourceSet resourceSet = behavior.eResource().getResourceSet();
            Resource newResource = null;
            Diagram cloneDiagram = null;
            try {
                GraphicalEditPart behaviorEditPart;
                IFigure borderedNodeImage;
                IFigure callActionBehaviorImage;
                newResource = resourceSet.createResource(URI.createURI((String)URIUtils.getTimestampedURI()));
                EcoreUtil.Copier copier = new EcoreUtil.Copier(true, true);
                cloneDiagram = (Diagram)copier.copy((EObject)diagram);
                copier.copyReferences();
                if (cloneDiagram != null) {
                    newResource.getContents().add((Object)cloneDiagram);
                }
                if ((callActionBehaviorImage = this.findInteractionWithSnapshotInFigure(borderedNodeImage = (behaviorEditPart = this.findBehaviorEditPart((EditPart)this.host, callBehaviorAction)).getFigure())) instanceof InteractionWithSnapshotFigure) {
                    ImageFigure imageFigure = ((InteractionWithSnapshotFigure)callActionBehaviorImage).getImageFigure();
                    PreferencesHint preferenceHint = this.getReferenceHint(diagram.getType());
                    Image image = CreateDiagramImage.getDiagramImage(cloneDiagram, preferenceHint, imageFigure, callBehaviorActionView);
                    ((InteractionWithSnapshotFigure)callActionBehaviorImage).setSnapshot(image);
                }
                CallBehaviorUtil.setDiagramLinked(callBehaviorActionView, (View)diagram);
                behaviorEditPart.refresh();
            }
            catch (Throwable throwable) {
                if (newResource != null) {
                    resourceSet.getResources().remove((Object)newResource);
                }
                if (cloneDiagram != null) {
                    cloneDiagram.unsetElement();
                    EcoreUtil.delete(cloneDiagram, (boolean)true);
                }
                throw throwable;
            }
            if (newResource != null) {
                resourceSet.getResources().remove((Object)newResource);
            }
            if (cloneDiagram != null) {
                cloneDiagram.unsetElement();
                EcoreUtil.delete((EObject)cloneDiagram, (boolean)true);
            }
        }
        return CommandResult.newOKCommandResult(diagram);
    }

    protected View getViewFromCommandResult(ICommand createElementCommand2) {
        CommandResult commandResult = this.createElementCommand.getCommandResult();
        Object resultAsObject = commandResult.getReturnValue();
        if (resultAsObject instanceof CreateViewRequest.ViewDescriptor) {
            CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)resultAsObject;
            return (View)viewDescriptor.getAdapter(View.class);
        }
        if (resultAsObject instanceof View) {
            return (View)resultAsObject;
        }
        return null;
    }

    protected PreferencesHint getReferenceHint(String type) {
        if ("PapyrusUMLSequenceDiagram".equals(type)) {
            return org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
        }
        if (PAPYRUS_UML_TIMING_DIAGRAM.equals(type)) {
            return new PreferencesHint(ORG_ECLIPSE_PAPYRUS_UML_DIAGRAM_TIMING);
        }
        if (InteractionOverviewDiagramEditPart.MODEL_ID.equals(type)) {
            return Activator.DIAGRAM_PREFERENCES_HINT;
        }
        if ("PapyrusUMLCommunicationDiagram".equals(type)) {
            return UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
        }
        return null;
    }

    protected GraphicalEditPart findBehaviorEditPart(EditPart parentEditPart, CallBehaviorAction callBehaviorAction) {
        for (Object child : parentEditPart.getChildren()) {
            GraphicalEditPart editPartChild;
            if (!(child instanceof GraphicalEditPart) || (editPartChild = (GraphicalEditPart)child).resolveSemanticElement() != callBehaviorAction) continue;
            return editPartChild;
        }
        return null;
    }

    protected IFigure findInteractionWithSnapshotInFigure(IFigure containerFigure) {
        for (Object childFigureAsObject : containerFigure.getChildren()) {
            if (!(childFigureAsObject instanceof IFigure)) continue;
            IFigure childFigure = (IFigure)childFigureAsObject;
            if (childFigure instanceof InteractionWithSnapshotFigure) {
                return childFigure;
            }
            if (childFigure.getChildren().isEmpty()) continue;
            return this.findInteractionWithSnapshotInFigure(childFigure);
        }
        return null;
    }

    protected Diagram findSequenceDiagram(Interaction interaction) {
        Object[] result;
        TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getDefault().getActiveShell());
        ServicesRegistry servicesRegistry = ((IMultiDiagramEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).getServicesRegistry();
        dialog.setContentProvider((ITreeContentProvider)new DiagramContentProvider(interaction));
        dialog.setInput((Object)servicesRegistry);
        try {
            dialog.setLabelProvider(((LabelProviderService)servicesRegistry.getService(LabelProviderService.class)).getLabelProvider());
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        dialog.setMessage(Messages.CreateSnapshotForInteractionFromViewDescriptorCommand_DiagramSelectorMessage);
        dialog.setTitle(Messages.CreateSnapshotForInteractionFromViewDescriptorCommand_DiagramSelectorTitle);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0) {
            return (Diagram)EMFHelper.getEObject((Object)result[0]);
        }
        return null;
    }
}

