/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.locator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.uml.diagram.common.locator.AdvancedBorderItemLocator;

public class CenterLocator
extends AdvancedBorderItemLocator {
    public CenterLocator(IFigure parentFigure, int location) {
        super(parentFigure, location);
    }

    public void relocate(IFigure borderItem) {
        Dimension size = this.getSize(borderItem);
        Rectangle rectSuggested = this.getConstraint();
        rectSuggested.setSize(size);
        Rectangle suggestedRectIndiagram = rectSuggested.getCopy();
        suggestedRectIndiagram.x += this.getParentFigure().getBounds().x;
        suggestedRectIndiagram.y += this.getParentFigure().getBounds().y;
        suggestedRectIndiagram = this.getValidLocation(suggestedRectIndiagram, borderItem);
        borderItem.setBounds(suggestedRectIndiagram.getCopy());
        suggestedRectIndiagram.x -= this.getParentFigure().getBounds().x;
        suggestedRectIndiagram.y -= this.getParentFigure().getBounds().y;
        this.setConstraint(suggestedRectIndiagram);
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        proposedLocation.setX(this.getParentFigure().getBounds().x + this.getParentFigure().getBounds().width / 2 - borderItem.getBounds().width() / 2);
        if (proposedLocation.y - proposedLocation.height / 2 <= this.getParentFigure().getBounds().y) {
            proposedLocation.setY(this.getParentFigure().getBounds().y);
        }
        if (proposedLocation.y - proposedLocation.height / 2 >= this.getParentFigure().getBounds().getBottomLeft().y) {
            proposedLocation.setY(this.getParentFigure().getBounds().getBottomLeft().y);
        }
        return super.getValidLocation(proposedLocation, borderItem);
    }
}

