/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.emf.resource.index.IWorkspaceModelIndexListener;
import org.eclipse.papyrus.infra.emf.resource.index.IWorkspaceModelIndexProvider;
import org.eclipse.papyrus.infra.emf.resource.index.WorkspaceModelIndex;
import org.eclipse.papyrus.uml.profile.Activator;

public class ProfileWorkspaceModelIndex {
    private WorkspaceModelIndex<URI> index;
    private static final ProfileWorkspaceModelIndex INSTANCE = new ProfileWorkspaceModelIndex();
    String[] profileExtension = new String[]{"profile.uml"};

    private ProfileWorkspaceModelIndex() {
        this.index = new WorkspaceModelIndex("PapyrusWorkspaceProfiles", "org.eclipse.uml2.uml", this.indexer());
    }

    protected WorkspaceModelIndex.IndexHandler<URI> indexer() {
        return new WorkspaceModelIndex.IndexHandler<URI>(){

            public URI index(IFile file) {
                return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            }

            public void unindex(IFile file) {
            }

            public boolean shouldIndex(IFile file) {
                return file.getFullPath().lastSegment().contains(".profile.uml");
            }
        };
    }

    public static ProfileWorkspaceModelIndex getInstance() {
        return INSTANCE;
    }

    public Collection<URI> getWorkspaceProfilesURIs() {
        Collection<Object> profiles = new ArrayList<URI>();
        try {
            profiles = ((Map)this.index.getIndex().get()).values();
        }
        catch (InterruptedException | ExecutionException e) {
            Activator.log.error((Throwable)e);
        }
        return profiles;
    }

    public void dispose() {
        this.index.dispose();
    }

    public WorkspaceModelIndex<URI> getIndex() {
        return this.index;
    }

    public void addListener(IWorkspaceModelIndexListener listener) {
        this.index.addListener(listener);
    }

    public void removeListener(IWorkspaceModelIndexListener listener) {
        this.index.removeListener(listener);
    }

    public static final class IndexProvider
    implements IWorkspaceModelIndexProvider {
        public WorkspaceModelIndex<?> get() {
            return INSTANCE.index;
        }
    }
}

