/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.security.AccessController;
import java.util.HashSet;
import org.eclipse.persistence.annotations.CacheKeyType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.PessimisticLockingPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractColumnMapping;
import org.eclipse.persistence.queries.UpdateObjectQuery;

public class CMPPolicy
implements Serializable,
Cloneable {
    protected Boolean forceUpdate = null;
    protected Boolean updateAllFields = null;
    protected PessimisticLockingPolicy pessimisticLockingPolicy;
    protected Class mappedClass;
    protected ClassDescriptor descriptor;
    protected int modificationDeferralLevel = 2;
    public static final int NONE = 0;
    public static final int UPDATE_MODIFICATIONS = 1;
    public static final int ALL_MODIFICATIONS = 2;
    protected int nonDeferredCreateTime = 0;
    public static final int UNDEFINED = 0;
    public static final int AFTER_EJBCREATE = 1;
    public static final int AFTER_EJBPOSTCREATE = 2;

    public int getNonDeferredCreateTime() {
        return this.nonDeferredCreateTime;
    }

    public PessimisticLockingPolicy getPessimisticLockingPolicy() {
        return this.pessimisticLockingPolicy;
    }

    public void setDeferModificationsUntilCommit(int deferralLevel) {
        this.modificationDeferralLevel = deferralLevel;
    }

    public void setMappedClass(Class newMappedClass) {
        this.mappedClass = newMappedClass;
    }

    public Class getMappedClass() {
        return this.mappedClass;
    }

    public void setNonDeferredCreateTime(int createTime) {
        this.nonDeferredCreateTime = createTime;
    }

    public void setPessimisticLockingPolicy(PessimisticLockingPolicy policy) {
        this.pessimisticLockingPolicy = policy;
    }

    public boolean hasPessimisticLockingPolicy() {
        return this.pessimisticLockingPolicy != null;
    }

    public int getDeferModificationsUntilCommit() {
        return this.modificationDeferralLevel;
    }

    public boolean getForceUpdate() {
        return Boolean.TRUE.equals(this.forceUpdate);
    }

    public void setForceUpdate(boolean shouldForceUpdate) {
        this.forceUpdate = shouldForceUpdate;
    }

    public boolean getUpdateAllFields() {
        return Boolean.TRUE.equals(this.updateAllFields);
    }

    public void setUpdateAllFields(boolean shouldUpdatAllFields) {
        this.updateAllFields = shouldUpdatAllFields;
    }

    public Boolean internalGetForceUpdate() {
        return this.forceUpdate;
    }

    public Boolean internalGetUpdateAllFields() {
        return this.updateAllFields;
    }

    public void internalSetForceUpdate(Boolean newForceUpdateValue) {
        this.forceUpdate = newForceUpdateValue;
    }

    public void internalSetUpdateAllFields(Boolean newUpdateAllFieldsValue) {
        this.updateAllFields = newUpdateAllFieldsValue;
    }

    public void initialize(ClassDescriptor descriptor, AbstractSession session) throws DescriptorException {
        if (this.getUpdateAllFields() && !descriptor.getQueryManager().hasUpdateQuery()) {
            descriptor.getQueryManager().setUpdateQuery(new UpdateObjectQuery());
        }
        if (this.getForceUpdate() && !this.getUpdateAllFields()) {
            throw DescriptorException.updateAllFieldsNotSet(descriptor);
        }
    }

    public void remoteInitialize(ClassDescriptor descriptor, AbstractSession session) throws DescriptorException {
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ClassDescriptor owningDescriptor) {
        this.descriptor = owningDescriptor;
    }

    protected void setFieldValue(KeyElementAccessor accessor, Object keyInstance, DatabaseMapping mapping, AbstractSession session, int[] elementIndex, Object ... keyElements) {
        if (mapping.isAggregateMapping()) {
            Object nestedObject = mapping.getRealAttributeValueFromObject(keyInstance, session);
            if (nestedObject == null) {
                nestedObject = this.getClassInstance(mapping.getReferenceDescriptor().getJavaClass());
                mapping.setRealAttributeValueInObject(keyInstance, nestedObject);
            }
            this.setFieldValue(accessor, nestedObject, mapping.getReferenceDescriptor().getObjectBuilder().getMappingForField(accessor.getDatabaseField()), session, elementIndex, keyElements);
        } else {
            Object fieldValue = null;
            if (mapping.isAbstractColumnMapping()) {
                fieldValue = keyElements[elementIndex[0]];
                Converter converter = ((AbstractColumnMapping)mapping).getConverter();
                if (converter != null) {
                    fieldValue = converter.convertDataValueToObjectValue(fieldValue, session);
                }
                elementIndex[0] = elementIndex[0] + 1;
            } else if (mapping.isObjectReferenceMapping()) {
                fieldValue = mapping.getReferenceDescriptor().getCMPPolicy().createPrimaryKeyInstanceFromPrimaryKeyValues(session, elementIndex, keyElements);
            }
            accessor.setValue(keyInstance, fieldValue);
        }
    }

    public boolean isCMP3Policy() {
        return false;
    }

    public CMPPolicy clone() {
        try {
            return (CMPPolicy)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception.getMessage());
        }
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
    }

    public Object createPrimaryKeyInstanceFromId(Object key, AbstractSession session) {
        if (this.descriptor.getCachePolicy().getCacheKeyType() == CacheKeyType.CACHE_ID) {
            return this.createPrimaryKeyInstanceFromPrimaryKeyValues(session, new int[1], ((CacheId)key).getPrimaryKey());
        }
        return this.createPrimaryKeyInstanceFromPrimaryKeyValues(session, new int[1], key);
    }

    public Object createPrimaryKeyInstanceFromPrimaryKeyValues(AbstractSession session, int[] elementIndex, Object ... keyElements) {
        Object keyInstance = null;
        KeyElementAccessor[] pkElementArray = this.getKeyClassFields();
        if (this.isSingleKey(pkElementArray)) {
            KeyElementAccessor[] keyElementAccessorArray = pkElementArray;
            int n = pkElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                KeyElementAccessor accessor = keyElementAccessorArray[n2];
                DatabaseMapping mapping = this.getDescriptor().getObjectBuilder().getMappingForAttributeName(accessor.getAttributeName());
                if (mapping != null && !mapping.isMultitenantPrimaryKeyMapping()) {
                    if (mapping.isAbstractColumnMapping()) {
                        Converter converter = ((AbstractColumnMapping)mapping).getConverter();
                        if (converter != null) {
                            return converter.convertDataValueToObjectValue(keyElements[elementIndex[0]], session);
                        }
                        keyInstance = keyElements[elementIndex[0]];
                    } else if (mapping.isObjectReferenceMapping()) {
                        keyInstance = mapping.getReferenceDescriptor().getCMPPolicy().createPrimaryKeyInstanceFromPrimaryKeyValues(session, elementIndex, keyElements);
                    }
                    elementIndex[0] = elementIndex[0] + 1;
                }
                if (keyInstance != null) {
                    return keyInstance;
                }
                ++n2;
            }
        } else {
            keyInstance = this.getPKClassInstance();
            int index = 0;
            while (index < pkElementArray.length) {
                KeyElementAccessor accessor = pkElementArray[index];
                DatabaseMapping mapping = this.getDescriptor().getObjectBuilder().getMappingForAttributeName(accessor.getAttributeName());
                if (mapping == null) {
                    mapping = this.getDescriptor().getObjectBuilder().getMappingForField(accessor.getDatabaseField());
                }
                if (accessor.isNestedAccessor()) {
                    this.setFieldValue(accessor, keyInstance, mapping.getReferenceDescriptor().getObjectBuilder().getMappingForField(accessor.getDatabaseField()), session, elementIndex, keyElements);
                } else {
                    if (mapping.isAggregateMapping()) {
                        mapping = mapping.getReferenceDescriptor().getObjectBuilder().getMappingForField(accessor.getDatabaseField());
                    }
                    this.setFieldValue(accessor, keyInstance, mapping, session, elementIndex, keyElements);
                }
                ++index;
            }
        }
        return keyInstance;
    }

    public Object createPrimaryKeyInstance(Object object, AbstractSession session) {
        KeyElementAccessor[] pkElementArray = this.getKeyClassFields();
        ObjectBuilder builder = this.getDescriptor().getObjectBuilder();
        if (pkElementArray.length == 1 && pkElementArray[0] instanceof KeyIsElementAccessor) {
            DatabaseMapping mapping = builder.getMappingForAttributeName(pkElementArray[0].getAttributeName());
            Object fieldValue = mapping.getRealAttributeValueFromObject(object, session);
            if (mapping.isObjectReferenceMapping()) {
                fieldValue = mapping.getReferenceDescriptor().getCMPPolicy().createPrimaryKeyInstance(fieldValue, session);
            }
            return fieldValue;
        }
        Object keyInstance = this.getPKClassInstance();
        HashSet<ObjectReferenceMapping> usedObjectReferenceMappings = new HashSet<ObjectReferenceMapping>();
        int index = 0;
        while (index < pkElementArray.length) {
            Object keyObj = object;
            KeyElementAccessor accessor = pkElementArray[index];
            DatabaseField field = accessor.getDatabaseField();
            DatabaseMapping mapping = builder.getMappingForField(field);
            if (!mapping.isObjectReferenceMapping() || !usedObjectReferenceMappings.contains(mapping)) {
                while (mapping.isAggregateObjectMapping()) {
                    keyObj = mapping.getRealAttributeValueFromObject(keyObj, session);
                    mapping = mapping.getReferenceDescriptor().getObjectBuilder().getMappingForField(field);
                }
                Object fieldValue = mapping.getRealAttributeValueFromObject(keyObj, session);
                if (mapping.isObjectReferenceMapping()) {
                    fieldValue = mapping.getReferenceDescriptor().getCMPPolicy().createPrimaryKeyInstance(fieldValue, session);
                    usedObjectReferenceMappings.add((ObjectReferenceMapping)mapping);
                }
                accessor.setValue(keyInstance, fieldValue);
            }
            ++index;
        }
        return keyInstance;
    }

    public Object getClassInstance(Class cls) {
        if (cls != null) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(cls));
                }
                return PrivilegedAccessHelper.newInstanceFromClass(cls);
            }
            catch (Exception e) {
                throw ValidationException.reflectiveExceptionWhileCreatingClassInstance(cls.getName(), e);
            }
        }
        return null;
    }

    public Object getPKClassInstance() {
        throw new RuntimeException("Should not get here.");
    }

    public Class getPKClass() {
        throw new RuntimeException("Should not get here.");
    }

    public Object createPrimaryKeyFromId(Object key, AbstractSession session) {
        throw new RuntimeException("Should not get here.");
    }

    public Object createBeanUsingKey(Object key, AbstractSession session) {
        throw new RuntimeException("Should not get here.");
    }

    protected KeyElementAccessor[] getKeyClassFields() {
        throw new RuntimeException("Should not get here.");
    }

    protected boolean isSingleKey(KeyElementAccessor[] pkElementArray) {
        if (pkElementArray.length == 1 && pkElementArray[0] instanceof KeyIsElementAccessor) {
            return true;
        }
        boolean foundFirstElement = false;
        KeyElementAccessor[] keyElementAccessorArray = pkElementArray;
        int n = pkElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            KeyElementAccessor accessor = keyElementAccessorArray[n2];
            if (!(accessor instanceof KeyIsElementAccessor)) {
                return false;
            }
            if (!accessor.getMapping().isMultitenantPrimaryKeyMapping()) {
                if (foundFirstElement) {
                    return false;
                }
                foundFirstElement = true;
            }
            ++n2;
        }
        return true;
    }

    protected static interface KeyElementAccessor {
        public String getAttributeName();

        public DatabaseField getDatabaseField();

        public DatabaseMapping getMapping();

        public Object getValue(Object var1, AbstractSession var2);

        public void setValue(Object var1, Object var2);

        public boolean isNestedAccessor();
    }

    protected static final class KeyIsElementAccessor
    implements KeyElementAccessor,
    Serializable {
        protected String attributeName;
        protected DatabaseField databaseField;
        protected DatabaseMapping mapping;

        public KeyIsElementAccessor(String attributeName, DatabaseField databaseField, DatabaseMapping mapping) {
            this.attributeName = attributeName;
            this.databaseField = databaseField;
            this.mapping = mapping;
        }

        @Override
        public String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public DatabaseField getDatabaseField() {
            return this.databaseField;
        }

        @Override
        public DatabaseMapping getMapping() {
            return this.mapping;
        }

        @Override
        public Object getValue(Object object, AbstractSession session) {
            return object;
        }

        @Override
        public boolean isNestedAccessor() {
            return false;
        }

        @Override
        public void setValue(Object object, Object value) {
        }
    }
}

