/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.model;

import java.util.LinkedList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.model.FortranElement;
import org.eclipse.photran.internal.core.model.FortranModelBuilder;
import org.eclipse.photran.internal.core.parser.ASTBlockDataSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTComponentDeclNode;
import org.eclipse.photran.internal.core.parser.ASTDataComponentDefStmtNode;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeDefNode;
import org.eclipse.photran.internal.core.parser.ASTErrorConstructNode;
import org.eclipse.photran.internal.core.parser.ASTErrorProgramUnitNode;
import org.eclipse.photran.internal.core.parser.ASTExternalNameListNode;
import org.eclipse.photran.internal.core.parser.ASTExternalStmtNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTGenericBindingNode;
import org.eclipse.photran.internal.core.parser.ASTGenericSpecNode;
import org.eclipse.photran.internal.core.parser.ASTInterfaceBlockNode;
import org.eclipse.photran.internal.core.parser.ASTInterfaceBodyNode;
import org.eclipse.photran.internal.core.parser.ASTIntrinsicListNode;
import org.eclipse.photran.internal.core.parser.ASTIntrinsicStmtNode;
import org.eclipse.photran.internal.core.parser.ASTMainProgramNode;
import org.eclipse.photran.internal.core.parser.ASTModuleNode;
import org.eclipse.photran.internal.core.parser.ASTModuleProcedureStmtNode;
import org.eclipse.photran.internal.core.parser.ASTNodeWithErrorRecoverySymbols;
import org.eclipse.photran.internal.core.parser.ASTProcedureNameListNode;
import org.eclipse.photran.internal.core.parser.ASTSpecificBindingNode;
import org.eclipse.photran.internal.core.parser.ASTStmtFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSubmoduleNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.GenericASTVisitor;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;

public final class FortranModelBuildingVisitor
extends GenericASTVisitor {
    private TranslationUnit translationUnit;
    private FortranModelBuilder modelBuilder;
    private LinkedList<IASTNode> parentParseTreeNodeStack = new LinkedList();
    private LinkedList<FortranElement> parentElementStack = new LinkedList();
    private FortranElement errorElement = null;

    public FortranModelBuildingVisitor(TranslationUnit translationUnit, FortranModelBuilder modelBuilder) {
        this.translationUnit = translationUnit;
        this.modelBuilder = modelBuilder;
    }

    private Parent getCurrentParent() {
        if (this.parentElementStack.isEmpty()) {
            return this.translationUnit;
        }
        return (Parent)this.parentElementStack.getLast();
    }

    private boolean isCurrentParent(IASTNode node) {
        if (this.parentParseTreeNodeStack.isEmpty()) {
            return false;
        }
        return node == this.parentParseTreeNodeStack.getLast();
    }

    private FortranElement getErrorElement() {
        if (this.errorElement == null) {
            this.errorElement = new FortranElement.ErrorNode((Parent)this.translationUnit, "Syntax Errors");
            this.addToModelNoChildren(this.errorElement);
        }
        return this.errorElement;
    }

    private void addToModel(IASTNode parseTreeNode, FortranElement element) {
        try {
            this.modelBuilder.addF90Element(element);
            this.beginAddingChildrenFor(parseTreeNode, element);
        }
        catch (CModelException cModelException) {}
    }

    private void addToModelNoChildren(FortranElement element) {
        try {
            this.modelBuilder.addF90Element(element);
        }
        catch (CModelException cModelException) {}
    }

    private void beginAddingChildrenFor(IASTNode parseTreeNode, FortranElement element) {
        this.parentParseTreeNodeStack.addLast(parseTreeNode);
        this.parentElementStack.addLast(element);
    }

    private void doneAddingChildrenFor(IASTNode node) {
        if (this.isCurrentParent(node)) {
            this.parentParseTreeNodeStack.removeLast();
            this.parentElementStack.removeLast();
        }
    }

    public void visitASTNode(IASTNode node) {
        this.traverseChildren(node);
        this.doneAddingChildrenFor(node);
    }

    private <T extends FortranElement> T setPos(T element, IASTNode astNode) {
        return this.setPos(element, astNode, false);
    }

    private <T extends FortranElement> T setPos(T element, IASTNode astNode, boolean setIdPos) {
        Token first = astNode.findFirstToken();
        Token last = astNode.findLastToken();
        if (first != null && last != null) {
            int offset = first.getFileOffset();
            int length = last.getFileOffset() + last.getLength() - offset;
            if (setIdPos) {
                element.setIdPos(offset, length);
            }
            element.setPos(offset, length);
            element.setLines(first.getLine(), last.getLine());
        }
        return element;
    }

    public void visitASTErrorProgramUnitNode(ASTErrorProgramUnitNode node) {
        this.addToModelNoChildren(this.setPos(this.configureElement((FortranElement)new FortranElement.ErrorNode(this.getCurrentParent(), "Erroneous program unit - " + this.describeError((ASTNodeWithErrorRecoverySymbols)node)), node.getErrorToken()), (IASTNode)node, true));
        this.addToModelNoChildren(this.configureElement((FortranElement)new FortranElement.ErrorNode((Parent)this.getErrorElement(), this.describeError((ASTNodeWithErrorRecoverySymbols)node)), node.getErrorToken()));
    }

    public void visitASTErrorConstructNode(ASTErrorConstructNode node) {
        this.addToModelNoChildren(this.setPos(this.configureElement((FortranElement)new FortranElement.ErrorNode(this.getCurrentParent(), "Unrecognized statement or construct - " + this.describeError((ASTNodeWithErrorRecoverySymbols)node)), node.getErrorToken()), (IASTNode)node, true));
        this.addToModelNoChildren(this.configureElement((FortranElement)new FortranElement.ErrorNode((Parent)this.getErrorElement(), this.describeError((ASTNodeWithErrorRecoverySymbols)node)), node.getErrorToken()));
    }

    private String describeError(ASTNodeWithErrorRecoverySymbols node) {
        StringBuilder sb = new StringBuilder();
        sb.append("Unexpected ");
        sb.append(node.getErrorToken());
        sb.append(" (line ");
        sb.append(node.getErrorToken().getLine());
        sb.append(", column ");
        sb.append(node.getErrorToken().getCol());
        sb.append(").  Expected one of the following: ");
        sb.append(node.describeTerminalsExpectedAtErrorPoint());
        return sb.toString();
    }

    public void visitASTMainProgramNode(ASTMainProgramNode node) {
        Token token = node.getProgramStmt() == null ? null : node.getProgramStmt().getProgramName().getProgramName();
        this.addToModel((IASTNode)node, this.setPos(this.configureElement((FortranElement)new FortranElement.MainProgram(this.getCurrentParent()), token), (IASTNode)node));
    }

    public void visitASTModuleNode(ASTModuleNode node) {
        Token token = node.getModuleStmt().getModuleName().getModuleName();
        this.addToModel((IASTNode)node, this.setPos(this.configureElement((FortranElement)new FortranElement.Module(this.getCurrentParent()), token), (IASTNode)node));
    }

    public void visitASTSubmoduleNode(ASTSubmoduleNode node) {
        Token token = node.getSubmoduleStmt().getSubmoduleName().getModuleName();
        this.addToModel((IASTNode)node, this.setPos(this.configureElement((FortranElement)new FortranElement.Submodule(this.getCurrentParent()), token), (IASTNode)node));
    }

    public void visitASTFunctionSubprogramNode(ASTFunctionSubprogramNode node) {
        Token token = node.getFunctionStmt().getFunctionName().getFunctionName();
        this.addToModel((IASTNode)node, this.setPos(this.configureElement((FortranElement)new FortranElement.Function(this.getCurrentParent()), token), (IASTNode)node));
    }

    public void visitASTSubroutineSubprogramNode(ASTSubroutineSubprogramNode node) {
        Token token = node.getSubroutineStmt().getSubroutineName().getSubroutineName();
        this.addToModel((IASTNode)node, this.setPos(this.configureElement((FortranElement)new FortranElement.Subroutine(this.getCurrentParent()), token), (IASTNode)node));
    }

    public void visitASTSpecificBindingNode(ASTSpecificBindingNode node) {
        Token token = node.getBindingName();
        this.addToModel((IASTNode)node, this.setPos(this.configureElement((FortranElement)new FortranElement.Subroutine(this.getCurrentParent()), token), (IASTNode)node));
    }

    public void visitASTGenericBindingNode(ASTGenericBindingNode node) {
        ASTGenericSpecNode spec;
        Token token = node.getGenericName() != null ? node.getGenericName().getGenericName() : ((spec = node.getGenericSpec()).isAssignmentOperator() ? spec.getEqualsToken() : (spec.isDefinedOperator() ? spec.getDefinedOperator().findFirstToken() : spec.findFirstToken()));
        this.addToModel((IASTNode)node, this.setPos(this.configureElement((FortranElement)new FortranElement.Subroutine(this.getCurrentParent()), token), (IASTNode)node));
    }

    public void visitASTBlockDataSubprogramNode(ASTBlockDataSubprogramNode node) {
        Token token = node.getBlockDataStmt().getBlockDataName() == null ? null : node.getBlockDataStmt().getBlockDataName().getBlockDataName();
        this.addToModel((IASTNode)node, this.setPos(this.configureElement((FortranElement)new FortranElement.BlockData(this.getCurrentParent()), token), (IASTNode)node));
    }

    public void visitASTDerivedTypeDefNode(ASTDerivedTypeDefNode node) {
        Token token = node.getDerivedTypeStmt().getTypeName();
        this.addToModel((IASTNode)node, this.setPos(this.configureElement((FortranElement)new FortranElement.DerivedType(this.getCurrentParent()), token), (IASTNode)node));
    }

    public void visitASTDataComponentDefStmtNode(ASTDataComponentDefStmtNode node) {
        for (ASTComponentDeclNode decl : node.getComponentDeclList()) {
            this.addToModelNoChildren(this.setPos(this.configureElement((FortranElement)new FortranElement.Variable(this.getCurrentParent()), decl.getComponentName().getComponentName()), (IASTNode)node));
        }
    }

    public void visitASTExternalStmtNode(ASTExternalStmtNode node) {
        IASTListNode list = node.getExternalNameList();
        int i = 0;
        while (i < list.size()) {
            this.addToModelNoChildren(this.setPos(this.configureElement((FortranElement)new FortranElement.Subprogram(this.getCurrentParent()), ((ASTExternalNameListNode)list.get(i)).getExternalName()), (IASTNode)node));
            ++i;
        }
    }

    public void visitASTInterfaceBlockNode(ASTInterfaceBlockNode node) {
        Token token = node.getInterfaceStmt().getGenericName() == null ? node.getInterfaceStmt().getInterfaceToken() : node.getInterfaceStmt().getGenericName().getGenericName();
        this.addToModel((IASTNode)node, this.setPos(this.configureElement((FortranElement)new FortranElement.Subprogram(this.getCurrentParent()), token), (IASTNode)node));
    }

    public void visitASTInterfaceBodyNode(ASTInterfaceBodyNode node) {
        if (node.getFunctionStmt() != null) {
            Token token = node.getFunctionStmt().getFunctionName().getFunctionName();
            this.addToModel((IASTNode)node, this.setPos(this.configureElement((FortranElement)new FortranElement.Function(this.getCurrentParent()), token), (IASTNode)node));
        } else if (node.getSubroutineStmt() != null) {
            Token token = node.getSubroutineStmt().getSubroutineName().getSubroutineName();
            this.addToModel((IASTNode)node, this.setPos(this.configureElement((FortranElement)new FortranElement.Subroutine(this.getCurrentParent()), token), (IASTNode)node));
        }
    }

    public void visitASTModuleProcedureStmtNode(ASTModuleProcedureStmtNode node) {
        IASTListNode list = node.getProcedureNameList();
        int i = 0;
        while (i < list.size()) {
            this.addToModelNoChildren(this.setPos(this.configureElement((FortranElement)new FortranElement.Subprogram(this.getCurrentParent()), ((ASTProcedureNameListNode)list.get(i)).getProcedureName()), (IASTNode)node));
            ++i;
        }
    }

    public void visitASTIntrinsicStmtNode(ASTIntrinsicStmtNode node) {
        IASTListNode list = node.getIntrinsicList();
        int i = 0;
        while (i < list.size()) {
            this.addToModelNoChildren(this.setPos(this.configureElement((FortranElement)new FortranElement.Subprogram(this.getCurrentParent()), ((ASTIntrinsicListNode)list.get(i)).getIntrinsicProcedureName()), (IASTNode)node));
            ++i;
        }
    }

    public void visitASTStmtFunctionStmtNode(ASTStmtFunctionStmtNode node) {
        this.addToModel((IASTNode)node, this.setPos(this.configureElement((FortranElement)new FortranElement.Variable(this.getCurrentParent()), node.getName().getName()), (IASTNode)node));
    }

    private FortranElement configureElement(FortranElement elt, Token nameToken) {
        this.modelBuilder.configureElement(elt, nameToken);
        return elt;
    }
}

