/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.cdtinterface.core;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.IContributedModelBuilder;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.photran.internal.cdtinterface.core.Messages;
import org.eclipse.photran.internal.cdtinterface.dom.IFortranDOMParser;
import org.eclipse.photran.internal.core.FortranCorePlugin;
import org.eclipse.photran.internal.core.model.EmptyFortranModelBuilder;
import org.eclipse.photran.internal.core.model.IFortranModelBuilder;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;

public class FortranLanguage
extends AbstractLanguage {
    public static final String LANGUAGE_ID = "org.eclipse.photran.cdtinterface.fortran";
    public static final String FORTRAN_MODEL_BUILDER_EXTENSION_POINT_ID = "org.eclipse.photran.cdtinterface.modelbuilder";
    public static final String FORTRAN_DOM_PARSER_EXTENSION_POINT_ID = "org.eclipse.photran.cdtinterface.domparser";

    public String getId() {
        return LANGUAGE_ID;
    }

    public String getName() {
        return Messages.FortranLanguage_Name;
    }

    public IContributedModelBuilder createModelBuilder(ITranslationUnit tu) {
        IFortranModelBuilder modelBuilder = null;
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(FORTRAN_MODEL_BUILDER_EXTENSION_POINT_ID);
        if (configs.length > 0) {
            int index = this.findPreferredModelBuilder(configs);
            try {
                modelBuilder = (IFortranModelBuilder)configs[index].createExecutableExtension("class");
            }
            catch (CoreException coreException) {}
        }
        if (modelBuilder == null) {
            modelBuilder = new EmptyFortranModelBuilder();
        }
        modelBuilder.setTranslationUnit(tu);
        return modelBuilder;
    }

    private int findPreferredModelBuilder(IConfigurationElement[] configs) {
        int i = 0;
        while (i < configs.length) {
            if (configs[i].getAttribute("id").equals(FortranPreferences.PREFERRED_MODEL_BUILDER.getValue())) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public IASTTranslationUnit getASTTranslationUnit(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, IIndex index, IParserLogService log) throws CoreException {
        IFortranDOMParser domParser = this.getDOMParser();
        if (domParser == null) {
            return null;
        }
        return domParser.getASTTranslationUnit(reader, scanInfo, fileCreator, index, log);
    }

    public IASTCompletionNode getCompletionNode(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, IIndex index, IParserLogService log, int offset) throws CoreException {
        IFortranDOMParser domParser = this.getDOMParser();
        if (domParser == null) {
            return null;
        }
        return domParser.getCompletionNode(reader, scanInfo, fileCreator, index, log, offset);
    }

    public IASTName[] getSelectedNames(IASTTranslationUnit ast, int start, int length) {
        IFortranDOMParser domParser = this.getDOMParser();
        if (domParser == null) {
            return new IASTName[0];
        }
        return domParser.getSelectedNames(ast, start, length);
    }

    private IFortranDOMParser getDOMParser() {
        IFortranDOMParser modelBuilder = null;
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(FORTRAN_DOM_PARSER_EXTENSION_POINT_ID);
        if (configs.length > 0) {
            int index = this.findPreferredDOMParser(configs);
            try {
                modelBuilder = (IFortranDOMParser)configs[index].createExecutableExtension("class");
            }
            catch (CoreException coreException) {}
        }
        return modelBuilder;
    }

    private int findPreferredDOMParser(IConfigurationElement[] configs) {
        int i = 0;
        while (i < configs.length) {
            if (configs[i].getAttribute("id").equals(FortranPreferences.PREFERRED_DOM_PARSER.getValue())) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public Collection getRegisteredContentTypeIds() {
        return Arrays.asList(FortranCorePlugin.getAllFortranContentTypes());
    }

    public int getLinkageID() {
        return 3;
    }
}

