/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.parser.php5;

import java.io.Reader;
import java_cup.runtime.Symbol;
import org.eclipse.php.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.core.compiler.ast.nodes.Comment;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.VarComment;
import org.eclipse.php.internal.core.ast.scanner.php5.PHPAstLexer;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.compiler.ast.parser.DocumentorLexer;

public class CompilerAstLexer
extends PHPAstLexer {
    private PHPDocBlock latestDocBlock;

    public CompilerAstLexer(Reader in) {
        super(in);
    }

    @Override
    protected void handleVarComment() {
        int end;
        int start;
        String content = this.yytext();
        VarComment varComment = ASTUtils.parseVarComment(content, start = this.getTokenStartPosition(), end = start + this.getTokenLength());
        if (varComment != null) {
            this.getCommentList().add(varComment);
        }
    }

    @Override
    protected void addComment(int type) {
        int leftPosition = this.getTokenStartPosition();
        Comment comment = new Comment(this.commentStartPosition, leftPosition + this.getTokenLength(), type);
        this.getCommentList().add(comment);
    }

    protected void addVarComment() {
    }

    @Override
    protected IDocumentorLexer getDocumentorLexer(Reader reader) {
        DocumentorLexer lexer = new DocumentorLexer(reader);
        return lexer;
    }

    @Override
    protected boolean parsePHPDoc() {
        boolean result = super.parsePHPDoc();
        if (result) {
            this.latestDocBlock = (PHPDocBlock)((Object)this.getCommentList().getLast());
        }
        return result;
    }

    @Override
    protected Symbol createSymbol(int symbolNumber) {
        Symbol symbol = super.createSymbol(symbolNumber);
        switch (symbolNumber) {
            case 34: 
            case 35: 
            case 42: 
            case 47: 
            case 48: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: {
                symbol.value = this.latestDocBlock;
            }
        }
        this.latestDocBlock = null;
        return symbol;
    }
}

