/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IStreamMonitor;

public class DebugConsoleMonitor
implements IFlushableStreamMonitor {
    private StringBuilder fContents = new StringBuilder();
    private Vector fListeners = new Vector(1);
    private boolean fBuffered = true;

    public void addListener(IStreamListener listener) {
        this.fListeners.add(listener);
    }

    public String getContents() {
        return this.fContents.toString();
    }

    public void removeListener(IStreamListener listener) {
        this.fListeners.remove(listener);
    }

    public void append(String message) {
        if (this.isBuffered()) {
            this.fContents.append(message);
        }
        Enumeration enumObject = this.fListeners.elements();
        while (enumObject.hasMoreElements()) {
            IStreamListener listener = (IStreamListener)enumObject.nextElement();
            listener.streamAppended(message, (IStreamMonitor)this);
        }
    }

    public void flushContents() {
        this.fContents.setLength(0);
    }

    public boolean isBuffered() {
        return this.fBuffered;
    }

    public void setBuffered(boolean buffer) {
        this.fBuffered = buffer;
    }
}

