/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.extract.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTNodes;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.nodes.BodyDeclaration;
import org.eclipse.php.core.ast.nodes.DoStatement;
import org.eclipse.php.core.ast.nodes.EchoStatement;
import org.eclipse.php.core.ast.nodes.ExpressionStatement;
import org.eclipse.php.core.ast.nodes.ForEachStatement;
import org.eclipse.php.core.ast.nodes.ForStatement;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.IFunctionBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.IVariableBinding;
import org.eclipse.php.core.ast.nodes.IfStatement;
import org.eclipse.php.core.ast.nodes.InfixExpression;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.SwitchStatement;
import org.eclipse.php.core.ast.nodes.TryStatement;
import org.eclipse.php.core.ast.nodes.VariableBinding;
import org.eclipse.php.core.ast.nodes.WhileStatement;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.corext.dom.LocalVariableIndex;
import org.eclipse.php.internal.core.corext.dom.Selection;
import org.eclipse.php.refactoring.core.PHPRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.code.flow.FlowContext;
import org.eclipse.php.refactoring.core.code.flow.FlowInfo;
import org.eclipse.php.refactoring.core.code.flow.InOutFlowAnalyzer;
import org.eclipse.php.refactoring.core.code.flow.InputFlowAnalyzer;
import org.eclipse.php.refactoring.core.visitor.CodeAnalyzer;
import org.eclipse.php.refactoring.core.visitor.ScopeSyntaxErrorsVisitor;

class ExtractFunctionAnalyzer
extends CodeAnalyzer {
    public static final int ERROR = -2;
    public static final int UNDEFINED = -1;
    public static final int NO = 0;
    public static final int EXPRESSION = 1;
    public static final int ACCESS_TO_LOCAL = 2;
    public static final int RETURN_STATEMENT_VOID = 3;
    public static final int RETURN_STATEMENT_VALUE = 4;
    public static final int MULTIPLE = 5;
    private ASTNode fEnclosingBodyDeclaration;
    private FlowInfo fInputFlowInfo;
    private FlowContext fInputFlowContext;
    private int fMaxVariableId;
    private int fReturnKind;
    private IFunctionBinding fEnclosingMethodBinding;
    private boolean fIsLastStatementSelected;
    private IVariableBinding fReturnValue;
    private IVariableBinding[] fArguments;

    public ExtractFunctionAnalyzer(Program cunit, ISourceModule sourceModule, IDocument document, Selection selection) throws CoreException, IOException {
        super(cunit, sourceModule, document, selection, false);
    }

    public RefactoringStatus checkInitialConditions() {
        int returns;
        RefactoringStatus result = this.getStatus();
        this.checkExpression(result);
        if (result.hasFatalError()) {
            return result;
        }
        this.fReturnKind = -1;
        this.fMaxVariableId = LocalVariableIndex.perform((ASTNode)this.getEnclosingBodyDeclaration());
        if (this.analyzeSelection(result).hasFatalError()) {
            return result;
        }
        int n = returns = this.fReturnKind == 0 ? 0 : 1;
        if (this.fReturnValue != null) {
            this.fReturnKind = 2;
            ++returns;
        }
        if (this.isExpressionSelected()) {
            this.fReturnKind = 1;
            ++returns;
        }
        if (returns > 1) {
            this.fReturnKind = 5;
            return result;
        }
        return result;
    }

    RefactoringStatus checkSelection(RefactoringStatus status, IProgressMonitor pm) {
        try {
            pm.beginTask("", 8);
            ASTNode[] selectedNodes = this.getSelectedNodes();
            if (selectedNodes == null || selectedNodes.length == 0) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.2"));
                return refactoringStatus;
            }
            pm.worked(1);
            ASTNode enclosingBodyNode = this.getFirstSelectedNode().getEnclosingBodyNode();
            if (enclosingBodyNode == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringCoreMessages.getString("ExtractVariableRefactoring.3"));
                return refactoringStatus;
            }
            pm.worked(1);
            if (this.scopeHasSyntaxErrors(enclosingBodyNode)) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)"Unable to activate refactoring. Please fix syntax errors");
                return refactoringStatus;
            }
            pm.worked(1);
            this.checkExpression(status);
            pm.worked(1);
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus analyzeSelection(RefactoringStatus status) {
        this.fInputFlowContext = new FlowContext(0, this.fMaxVariableId + 1);
        this.fInputFlowContext.setConsiderAccessMode(true);
        this.fInputFlowContext.setComputeMode(FlowContext.ARGUMENTS);
        InOutFlowAnalyzer flowAnalyzer = new InOutFlowAnalyzer(this.fInputFlowContext);
        this.fInputFlowInfo = flowAnalyzer.perform(this.getSelectedNodes());
        if (this.fInputFlowInfo.branches()) {
            status.addFatalError(PHPRefactoringCoreMessages.getString("ExtractFunctionAnalyzer.0"));
            this.fReturnKind = -2;
            return status;
        }
        if (this.fInputFlowInfo.isValueReturn()) {
            this.fReturnKind = 4;
        } else if (this.fInputFlowInfo.isVoidReturn() || this.fInputFlowInfo.isPartialReturn() && this.isVoidMethod() && this.isLastStatementSelected()) {
            this.fReturnKind = 3;
        } else if (this.fInputFlowInfo.isNoReturn() || this.fInputFlowInfo.isThrow() || this.fInputFlowInfo.isUndefined()) {
            this.fReturnKind = 0;
        }
        this.computeInput();
        this.computeOutput(status);
        return status;
    }

    private void computeOutput(RefactoringStatus status) {
        FlowContext flowContext = new FlowContext(0, this.fMaxVariableId + 1);
        flowContext.setConsiderAccessMode(true);
        flowContext.setComputeMode(FlowContext.RETURN_VALUES);
        FlowInfo returnInfo = new InOutFlowAnalyzer(flowContext).perform(this.getSelectedNodes());
        IVariableBinding[] returnValues = returnInfo.get(flowContext, 56);
        IRegion region = this.getSelectedNodeRange();
        Selection selection = Selection.createFromStartLength((int)region.getOffset(), (int)region.getLength());
        int counter = 0;
        flowContext.setComputeMode(FlowContext.ARGUMENTS);
        FlowInfo argInfo = null;
        argInfo = this.fEnclosingBodyDeclaration instanceof MethodDeclaration ? new InputFlowAnalyzer(flowContext, selection, true).perform((ASTNode)((MethodDeclaration)this.fEnclosingBodyDeclaration).getFunction()) : (this.fEnclosingBodyDeclaration instanceof FunctionDeclaration ? new InputFlowAnalyzer(flowContext, selection, true).perform(this.fEnclosingBodyDeclaration) : new InputFlowAnalyzer(flowContext, selection, true).perform(this.fEnclosingBodyDeclaration));
        IVariableBinding[] reads = argInfo.get(flowContext, 38);
        int i = 0;
        while (i < returnValues.length && counter <= 1) {
            IVariableBinding binding = returnValues[i];
            int x = 0;
            while (x < reads.length) {
                if (reads[x].equals((Object)binding)) {
                    ++counter;
                    this.fReturnValue = binding;
                    break;
                }
                ++x;
            }
            ++i;
        }
        switch (counter) {
            case 0: {
                this.fReturnValue = null;
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.fReturnValue = null;
                status.addFatalError(PHPRefactoringCoreMessages.getString("ExtractFunctionAnalyzer.1"));
                return;
            }
        }
    }

    private boolean isVoidMethod() {
        ITypeBinding[] binding;
        if (this.fEnclosingMethodBinding == null) {
            return true;
        }
        ITypeBinding[] iTypeBindingArray = binding = this.fEnclosingMethodBinding.getReturnType();
        int n = binding.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding currentBinding = iTypeBindingArray[n2];
            if (this.fEnclosingBodyDeclaration.getAST().resolveWellKnownType("void").equals((Object)currentBinding)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isLastStatementSelected() {
        return this.fIsLastStatementSelected;
    }

    private void checkExpression(RefactoringStatus status) {
        ASTNode node;
        ASTNode[] nodes = this.getSelectedNodes();
        if (!(nodes == null || nodes.length != 1 || (node = nodes[0]) instanceof ExpressionStatement || node instanceof EchoStatement || node instanceof InfixExpression || node instanceof ForStatement || node instanceof DoStatement || node instanceof ForEachStatement || node instanceof IfStatement || node instanceof SwitchStatement || node instanceof TryStatement || node instanceof WhileStatement)) {
            status.addFatalError(PHPRefactoringCoreMessages.getString("ExtractFunctionAnalyzer.2"));
        }
        if (nodes == null || nodes.length == 0) {
            status.addFatalError(PHPRefactoringCoreMessages.getString("ExtractFunctionAnalyzer.3"));
        }
    }

    private boolean scopeHasSyntaxErrors(ASTNode enclosingBodyNode) {
        ScopeSyntaxErrorsVisitor visitor = new ScopeSyntaxErrorsVisitor();
        switch (enclosingBodyNode.getType()) {
            case 29: {
                ((FunctionDeclaration)enclosingBodyNode).getBody().accept((Visitor)visitor);
                break;
            }
            case 46: {
                enclosingBodyNode.accept((Visitor)visitor);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return visitor.hasSyntaxError;
    }

    public ASTNode getEnclosingBodyDeclaration() {
        this.fEnclosingBodyDeclaration = (BodyDeclaration)ASTNodes.getParent((ASTNode)this.getFirstSelectedNode(), BodyDeclaration.class);
        if (this.fEnclosingBodyDeclaration == null) {
            this.fEnclosingBodyDeclaration = (Statement)ASTNodes.getParent((ASTNode)this.getFirstSelectedNode(), FunctionDeclaration.class);
        }
        if (this.fEnclosingBodyDeclaration == null) {
            this.fEnclosingBodyDeclaration = ASTNodes.getParent((ASTNode)this.getFirstSelectedNode(), Program.class);
        }
        return this.fEnclosingBodyDeclaration;
    }

    private void computeInput() {
        int argumentMode = 54;
        this.fArguments = this.removeSelectedDeclarations(this.fInputFlowInfo.get(this.fInputFlowContext, argumentMode));
    }

    public IVariableBinding getReturnValue() {
        return this.fReturnValue;
    }

    private void computeLastStatementSelected() {
        ASTNode[] nodes = this.getSelectedNodes();
        if (nodes.length == 0) {
            this.fIsLastStatementSelected = false;
        } else {
            Block body = null;
            if (this.fEnclosingBodyDeclaration instanceof FunctionDeclaration) {
                body = ((FunctionDeclaration)this.fEnclosingBodyDeclaration).getBody();
            }
            if (this.fEnclosingBodyDeclaration instanceof MethodDeclaration) {
                body = ((MethodDeclaration)this.fEnclosingBodyDeclaration).getFunction().getBody();
            }
            if (body != null) {
                List statements = body.statements();
                this.fIsLastStatementSelected = nodes[nodes.length - 1] == statements.get(statements.size() - 1);
            }
        }
    }

    @Override
    public void endVisit(Program program) {
        this.computeLastStatementSelected();
        super.endVisit(program);
    }

    public int getReturnKind() {
        return this.fReturnKind;
    }

    public IVariableBinding[] getArguments() {
        return this.fArguments;
    }

    private IVariableBinding[] removeSelectedDeclarations(IVariableBinding[] bindings) {
        ArrayList<IVariableBinding> result = new ArrayList<IVariableBinding>(bindings.length);
        Selection selection = this.getSelection();
        int i = 0;
        while (i < bindings.length) {
            if (!selection.covers((ASTNode)((VariableBinding)bindings[i]).getVarialbe())) {
                // empty if block
            }
            result.add(bindings[i]);
            ++i;
        }
        return result.toArray(new IVariableBinding[result.size()]);
    }
}

