/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.core.network.server.TeslaNetworkClientConnection;

public class TeslaNetworkServer
extends Thread {
    private boolean running = true;
    private volatile boolean isStarted = false;
    private final ServerSocket socket;
    private final List<TeslaNetworkClientConnection> clients = new ArrayList<TeslaNetworkClientConnection>();
    private int port;

    public TeslaNetworkServer(int port) throws IOException {
        super("Tesla network server:" + Integer.toString(port));
        this.port = port;
        this.socket = new ServerSocket(port);
        this.socket.setSoTimeout(300000);
    }

    public int getPort() {
        return this.port;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.isStarted = true;
        try {
            while (this.running && this.socket != null && !this.socket.isClosed() && !this.isInterrupted()) {
                try {
                    Socket clientSocket = this.socket.accept();
                    TeslaNetworkClientConnection client = new TeslaNetworkClientConnection(clientSocket, this);
                    client.start();
                    List<TeslaNetworkClientConnection> list = this.clients;
                    synchronized (list) {
                        this.clients.add(client);
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (IOException e) {
                    if (!this.running) continue;
                    TeslaCore.log(e);
                }
            }
        }
        catch (Throwable throwable) {
            if (this.socket == null) throw throwable;
            try {
                this.socket.close();
                throw throwable;
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        if (this.socket == null) return;
        try {
            this.socket.close();
            return;
        }
        catch (Throwable throwable) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        TeslaNetworkClientConnection[] clientsCopy;
        if (this.socket != null) {
            this.running = false;
            try {
                this.socket.close();
            }
            catch (IOException e) {
                TeslaCore.log(e);
            }
        }
        List<TeslaNetworkClientConnection> list = this.clients;
        synchronized (list) {
            clientsCopy = this.clients.toArray(new TeslaNetworkClientConnection[this.clients.size()]);
        }
        TeslaNetworkClientConnection[] teslaNetworkClientConnectionArray = clientsCopy;
        int n = clientsCopy.length;
        int n2 = 0;
        while (n2 < n) {
            TeslaNetworkClientConnection client = teslaNetworkClientConnectionArray[n2];
            client.shutdown();
            ++n2;
        }
        this.clients.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(TeslaNetworkClientConnection client) {
        List<TeslaNetworkClientConnection> list = this.clients;
        synchronized (list) {
            this.clients.remove(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasClients() {
        boolean result = false;
        List<TeslaNetworkClientConnection> list = this.clients;
        synchronized (list) {
            result = !this.clients.isEmpty();
        }
        return result;
    }
}

