/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import org.eclipse.sapphire.Color;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.SectionDef;
import org.eclipse.sapphire.ui.forms.SectionPart;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.forms.swt.SapphireKeyboardActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.SapphireToolBarActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.sapphire.ui.forms.swt.internal.CompositePresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.text.SapphireFormText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public final class SectionPresentation
extends CompositePresentation {
    private SapphireActionPresentationManager actionPresentationManager;
    private Section section;
    private SapphireFormText descriptionFormText;
    private Composite descriptionSpacer;
    private Composite sectionContentOuterComposite;
    private Composite sectionContentInnerComposite;

    public SectionPresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
        super(part, parent, composite);
    }

    @Override
    public SectionPart part() {
        return (SectionPart)super.part();
    }

    @Override
    protected Composite renderOuterComposite(GridData gd) {
        final SectionPart part = this.part();
        SectionDef def = part.definition();
        FormToolkit toolkit = new FormToolkit(this.composite().getDisplay());
        Composite outerComposite = new Composite(this.composite(), 0);
        outerComposite.setLayoutData((Object)GridLayoutUtil.gdhspan(this.part().getScaleVertically() ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), 2));
        outerComposite.setLayout((Layout)GridLayoutUtil.glayout(1, 10, 10, 10, 20));
        this.register((Control)outerComposite);
        boolean collapsible = (Boolean)def.getCollapsible().content();
        int style = 0x100 | (collapsible ? 2 : 0);
        this.section = toolkit.createSection(outerComposite, style);
        this.section.setLayoutData((Object)GridLayoutUtil.gdfill());
        if (collapsible) {
            this.section.setExpanded(!part.folded());
            this.section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    if (event.getState()) {
                        part.unfold();
                    } else {
                        part.fold();
                    }
                }
            });
        }
        this.sectionContentOuterComposite = new Composite((Composite)this.section, 0);
        this.sectionContentOuterComposite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0));
        org.eclipse.swt.graphics.Color bgcolor = this.resources().color(part.getBackgroundColor(), Color.WHITE);
        this.sectionContentOuterComposite.setBackground(bgcolor);
        this.sectionContentOuterComposite.setBackgroundMode(1);
        this.attachPartListener(new Listener(){

            public void handle(Event event) {
                if (event instanceof SectionPart.TitleEvent) {
                    SectionPresentation.this.refreshTitle();
                } else if (event instanceof SectionPart.DescriptionEvent) {
                    SectionPresentation.this.refreshDescription();
                }
            }
        });
        this.refreshTitle();
        this.refreshDescription();
        this.sectionContentInnerComposite = new Composite(this.sectionContentOuterComposite, 0);
        this.sectionContentInnerComposite.setLayoutData((Object)GridLayoutUtil.gdfill());
        this.sectionContentInnerComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
        SapphireActionGroup actions = part.getActions();
        this.actionPresentationManager = new SapphireActionPresentationManager(this, actions);
        SapphireToolBarActionPresentation toolBarActionsPresentation = new SapphireToolBarActionPresentation(this.actionPresentationManager);
        ToolBar toolbar = new ToolBar((Composite)this.section, 8519936);
        toolBarActionsPresentation.setToolBar(toolbar);
        toolBarActionsPresentation.render();
        this.section.setTextClient((Control)toolbar);
        SapphireKeyboardActionPresentation keyboardActionsPresentation = new SapphireKeyboardActionPresentation(this.actionPresentationManager);
        keyboardActionsPresentation.attach((Control)toolbar);
        keyboardActionsPresentation.render();
        toolkit.paintBordersFor((Composite)this.section);
        this.section.setClient((Control)this.sectionContentOuterComposite);
        return this.sectionContentInnerComposite;
    }

    private void refreshTitle() {
        String title = this.part().title();
        if (title == null) {
            title = "#null#";
        } else {
            title = title.trim();
            title = ((LocalizationService)this.part().definition().adapt(LocalizationService.class)).transform(title, CapitalizationType.TITLE_STYLE, false);
        }
        this.section.setText(title.trim());
    }

    private void refreshDescription() {
        String description = this.part().description();
        if (description != null && (description = description.trim()).length() == 0) {
            description = null;
        }
        if (description == null) {
            if (this.descriptionFormText != null) {
                this.descriptionFormText.dispose();
                this.descriptionFormText = null;
                this.descriptionSpacer.dispose();
                this.descriptionSpacer = null;
            }
        } else {
            if (this.descriptionFormText == null) {
                this.descriptionFormText = new SapphireFormText(this.sectionContentOuterComposite, 0);
                this.descriptionFormText.setLayoutData(GridLayoutUtil.gdhindent(GridLayoutUtil.gdwhint(GridLayoutUtil.gdhfill(), 100), 9));
                SwtUtil.reflowOnResize((Control)this.descriptionFormText);
                this.descriptionSpacer = new Composite(this.sectionContentOuterComposite, 0);
                this.descriptionSpacer.setLayoutData((Object)GridLayoutUtil.gdhhint(GridLayoutUtil.gdhfill(), 5));
                this.descriptionSpacer.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0, 0, 0));
                if (this.sectionContentInnerComposite != null) {
                    this.descriptionFormText.moveAbove((Control)this.sectionContentInnerComposite);
                    this.descriptionSpacer.moveAbove((Control)this.sectionContentInnerComposite);
                }
            }
            description = description.replace("<", "&lt;");
            StringBuilder buf = new StringBuilder();
            buf.append("<form><p vspace=\"false\">");
            buf.append(description);
            buf.append("</p></form>");
            this.descriptionFormText.setText(buf.toString(), true, false);
        }
        this.sectionContentOuterComposite.layout();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.actionPresentationManager != null) {
            this.actionPresentationManager.dispose();
            this.actionPresentationManager = null;
        }
        this.section = null;
        this.descriptionFormText = null;
        this.descriptionSpacer = null;
        this.sectionContentOuterComposite = null;
        this.sectionContentInnerComposite = null;
    }
}

