/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.text.edits.TextEdit;

public class SourceFormatOperation
implements IOperation {
    private final IJavaProject m_project;
    private Document m_document;
    private ISourceRange m_range;
    private int m_indent = 0;

    public SourceFormatOperation(ICompilationUnit icu) throws JavaModelException {
        this(icu.getJavaProject(), new Document(icu.getSource()), icu.getSourceRange());
    }

    public SourceFormatOperation(IJavaProject project, Document document) {
        this(project, document, (ISourceRange)new SourceRange(0, document.getLength()));
    }

    public SourceFormatOperation(IJavaProject project, Document document, ISourceRange range) {
        this.m_project = project;
        this.m_document = document;
        this.m_range = range;
    }

    @Override
    public String getOperationName() {
        return "Format source";
    }

    @Override
    public void validate() {
        if (this.getProject() == null) {
            throw new IllegalArgumentException("java project can not be null.");
        }
        if (this.getDocument() == null) {
            throw new IllegalArgumentException("document can not be null.");
        }
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        try {
            TextEdit te;
            Document document = this.getDocument();
            ISourceRange range = this.getRange();
            if (range == null) {
                range = new SourceRange(0, document.getLength());
            }
            CodeFormatter formatter = ToolFactory.createCodeFormatter((Map)this.getProject().getOptions(true));
            int kind = 4096;
            String defaultLineDelimiter = document.getDefaultLineDelimiter();
            if (defaultLineDelimiter == null) {
                defaultLineDelimiter = S2eUtils.lineSeparator(this.getProject());
            }
            if ((te = formatter.format(kind, document.get(), range.getOffset(), range.getLength(), this.m_indent, defaultLineDelimiter)) != null) {
                te.apply((IDocument)document);
            }
        }
        catch (Exception e) {
            SdkLog.error((String)"Unable to format source.", (Object[])new Object[]{e});
        }
    }

    public ISourceRange getRange() {
        return this.m_range;
    }

    public void setRange(ISourceRange range) {
        this.m_range = range;
    }

    public Document getDocument() {
        return this.m_document;
    }

    public void setDocument(Document document) {
        this.m_document = document;
    }

    public int getIndent() {
        return this.m_indent;
    }

    public void setIndent(int indent) {
        this.m_indent = indent;
    }

    public IJavaProject getProject() {
        return this.m_project;
    }
}

