/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.jaxws;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.ICompilationUnit;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.jaxws.JaxWsUtils;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.RawSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.annotation.IAnnotationSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.CompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;
import org.eclipse.scout.sdk.s2e.CachingJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.IJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebServiceUpdateOperation
implements IOperation {
    private String m_package;
    private final Collection<IFile> m_jaxwsBindingFiles = new LinkedList<IFile>();
    private final Collection<BindingClassUpdate> m_bindingClassUpdates = new LinkedList<BindingClassUpdate>();
    private final Collection<EntryPointDefinitionUpdate> m_entryPointDefinitionUpdates = new LinkedList<EntryPointDefinitionUpdate>();
    private final Collection<WebServiceClientUpdate> m_webServiceClientUpdates = new LinkedList<WebServiceClientUpdate>();
    private final Collection<WebServiceImplementationUpdate> m_webServiceImplUpdates = new LinkedList<WebServiceImplementationUpdate>();
    private final IJavaEnvironmentProvider m_provider;

    public WebServiceUpdateOperation() {
        this(new CachingJavaEnvironmentProvider());
    }

    protected WebServiceUpdateOperation(IJavaEnvironmentProvider provider) {
        this.m_provider = (IJavaEnvironmentProvider)Validate.notNull((Object)provider);
    }

    @Override
    public String getOperationName() {
        return "Update Web Service";
    }

    @Override
    public void validate() {
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getOperationName(), (int)40);
        if (progress.isCanceled()) {
            return;
        }
        this.updateJaxWsBinding((IProgressMonitor)progress.newChild(10), workingCopyManager);
        this.updateEntryPointDefinitions((IProgressMonitor)progress.newChild(10), workingCopyManager);
        this.updateWebServiceClients((IProgressMonitor)progress.newChild(10), workingCopyManager);
        this.updateWebServiceImpls((IProgressMonitor)progress.newChild(10), workingCopyManager);
        workingCopyManager.unregisterAll(monitor, true);
    }

    protected void updateWebServiceImpls(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        if (this.m_webServiceImplUpdates.isEmpty()) {
            return;
        }
        for (WebServiceImplementationUpdate up : this.m_webServiceImplUpdates) {
            ICompilationUnit wsImpl = S2eUtils.jdtTypeToScoutType(up.getWebServiceImpl(), this.m_provider.get(up.getWebServiceImpl().getJavaProject())).compilationUnit();
            CompilationUnitSourceBuilder builder = new CompilationUnitSourceBuilder(wsImpl);
            ITypeSourceBuilder mainType = builder.getMainType();
            for (String oldIfcSig : mainType.getInterfaceSignatures()) {
                builder.removeDeclaredImport(Signature.toString((String)oldIfcSig));
            }
            WebServiceUpdateOperation.updateWsdlFaults((ICompilationUnitSourceBuilder)builder, up.getPackage());
            String newPortTypeFqn = String.valueOf(up.getPackage()) + '.' + up.getPortTypeName();
            mainType.setInterfaceSignatures(Collections.singletonList(Signature.createTypeSignature((String)newPortTypeFqn)));
            S2eUtils.writeType((IPackageFragmentRoot)up.getWebServiceImpl().getAncestor(3), (ICompilationUnitSourceBuilder)builder, wsImpl.javaEnvironment(), monitor, workingCopyManager);
        }
    }

    protected static void updateWsdlFaults(ICompilationUnitSourceBuilder icuBuilder, String newPackage) {
        for (IMethodSourceBuilder msb : icuBuilder.getMainType().getMethods()) {
            ArrayList exceptionSignatures = new ArrayList(msb.getExceptionSignatures());
            for (String excSig : exceptionSignatures) {
                msb.removeExceptionSignature(excSig);
                msb.addExceptionSignature(Signature.createTypeSignature((String)(String.valueOf(newPackage) + '.' + Signature.getSignatureSimpleName((String)excSig))));
                icuBuilder.removeDeclaredImport(Signature.toString((String)excSig));
            }
        }
    }

    protected void updateWebServiceClients(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        if (this.m_webServiceClientUpdates.isEmpty()) {
            return;
        }
        for (WebServiceClientUpdate up : this.m_webServiceClientUpdates) {
            String[] typeParameters;
            ICompilationUnit wsClient = S2eUtils.jdtTypeToScoutType(up.getWebServiceClient(), this.m_provider.get(up.getWebServiceClient().getJavaProject())).compilationUnit();
            CompilationUnitSourceBuilder builder = new CompilationUnitSourceBuilder(wsClient);
            ITypeSourceBuilder mainType = builder.getMainType();
            String[] stringArray = typeParameters = Signature.getTypeArguments((String)mainType.getSuperTypeSignature());
            int n = typeParameters.length;
            int n2 = 0;
            while (n2 < n) {
                String oldImport = stringArray[n2];
                builder.removeDeclaredImport(Signature.toString((String)oldImport));
                ++n2;
            }
            String newPortTypeFqn = String.valueOf(up.getPackage()) + '.' + up.getPortTypeName();
            String newWebServiceFqn = String.valueOf(up.getPackage()) + '.' + up.getWebServiceName();
            mainType.setInterfaceSignatures(Collections.singletonList(Signature.createTypeSignature((String)newPortTypeFqn)));
            StringBuilder superTypeFqnBuilder = new StringBuilder("org.eclipse.scout.rt.server.jaxws.consumer.AbstractWebServiceClient");
            superTypeFqnBuilder.append('<').append(newWebServiceFqn).append(", ").append(newPortTypeFqn).append('>');
            mainType.setSuperTypeSignature(Signature.createTypeSignature((String)superTypeFqnBuilder.toString()));
            WebServiceUpdateOperation.updateWsdlFaults((ICompilationUnitSourceBuilder)builder, up.getPackage());
            S2eUtils.writeType((IPackageFragmentRoot)up.getWebServiceClient().getAncestor(3), (ICompilationUnitSourceBuilder)builder, wsClient.javaEnvironment(), monitor, workingCopyManager);
        }
    }

    protected void updateJaxWsBinding(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        if (this.getJaxwsBindingFiles().isEmpty()) {
            return;
        }
        for (IFile jaxwsBindingFile : this.getJaxwsBindingFiles()) {
            Document document = S2eUtils.readXmlDocument(jaxwsBindingFile);
            String prefix = document.lookupPrefix("http://java.sun.com/xml/ns/jaxws");
            try {
                Element packageNameElement;
                for (BindingClassUpdate up : this.m_bindingClassUpdates) {
                    Element nodeElement = JaxWsUtils.getJaxWsBindingElement((String)up.getNodeValue(), (Document)document);
                    Element portTypeNameClassElement = CoreUtils.getFirstChildElement((Element)nodeElement, (String)"class");
                    if (portTypeNameClassElement == null) continue;
                    portTypeNameClassElement.setAttribute("name", up.getClassName());
                }
                Element packageElement = JaxWsUtils.getJaxWsBindingElement((String)"wsdl:definitions", (Document)document);
                if (packageElement == null) {
                    packageElement = document.createElement(String.valueOf(prefix) + ':' + "bindings");
                    packageElement.setAttribute("node", "wsdl:definitions");
                    document.getDocumentElement().appendChild(packageElement);
                }
                if ((packageNameElement = CoreUtils.getFirstChildElement((Element)packageElement, (String)"package")) == null) {
                    packageNameElement = document.createElement(String.valueOf(prefix) + ':' + "package");
                    packageElement.appendChild(packageNameElement);
                }
                packageNameElement.setAttribute("name", this.getPackage());
            }
            catch (XPathExpressionException e) {
                throw new CoreException((IStatus)new ScoutStatus(e));
            }
            S2eUtils.writeXmlDocument(document, jaxwsBindingFile, monitor, workingCopyManager);
        }
    }

    protected void updateEntryPointDefinitions(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        for (EntryPointDefinitionUpdate up : this.m_entryPointDefinitionUpdates) {
            IType entryPointDefinition = up.getEntryPointDefinition();
            if (!S2eUtils.exists((IJavaElement)entryPointDefinition)) continue;
            IJavaEnvironment env = this.m_provider.get(entryPointDefinition.getJavaProject());
            ICompilationUnit definition = S2eUtils.jdtTypeToScoutType(entryPointDefinition, env).compilationUnit();
            CompilationUnitSourceBuilder builder = new CompilationUnitSourceBuilder(definition);
            builder.removeAllDeclaredImports();
            for (IAnnotationSourceBuilder annotationSourceBuilder : builder.getMainType().getAnnotations()) {
                if (!annotationSourceBuilder.getName().equals("org.eclipse.scout.rt.server.jaxws.provider.annotation.WebServiceEntryPoint")) continue;
                final String newPortTypeFqn = String.valueOf(up.getPortTypePackage()) + '.' + up.getPortTypeName();
                annotationSourceBuilder.putElement("endpointInterface", new ISourceBuilder(){

                    public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                        source.append(validator.useName(newPortTypeFqn)).append(".class");
                    }
                });
                annotationSourceBuilder.putElement("entryPointName", (ISourceBuilder)new RawSourceBuilder(CoreUtils.toStringLiteral((String)up.getEntryPointName())));
                annotationSourceBuilder.putElement("entryPointPackage", (ISourceBuilder)new RawSourceBuilder(CoreUtils.toStringLiteral((String)up.getEntryPointPackage())));
                break;
            }
            S2eUtils.writeType((IPackageFragmentRoot)entryPointDefinition.getAncestor(3), (ICompilationUnitSourceBuilder)builder, definition.javaEnvironment(), monitor, workingCopyManager);
        }
    }

    public Collection<IFile> getJaxwsBindingFiles() {
        return Collections.unmodifiableCollection(this.m_jaxwsBindingFiles);
    }

    public void setJaxwsBindingFiles(Collection<? extends IFile> files) {
        this.m_jaxwsBindingFiles.addAll(files);
    }

    public String getPackage() {
        return this.m_package;
    }

    public void setPackage(String package1) {
        this.m_package = package1;
    }

    public void addWebServiceImplementationUpdate(WebServiceImplementationUpdate up) {
        this.m_webServiceImplUpdates.add(up);
    }

    public void addBindingClassUpdate(BindingClassUpdate up) {
        this.m_bindingClassUpdates.add(up);
    }

    public void addEntryPointDefinitionUpdate(EntryPointDefinitionUpdate up) {
        this.m_entryPointDefinitionUpdates.add(up);
    }

    public void addWebServiceClientUpdate(WebServiceClientUpdate up) {
        this.m_webServiceClientUpdates.add(up);
    }

    public static class BindingClassUpdate {
        private String m_nodeValue;
        private String m_className;

        public BindingClassUpdate(String nodeValue, String className) {
            this.m_nodeValue = nodeValue;
            this.m_className = className;
        }

        public String getNodeValue() {
            return this.m_nodeValue;
        }

        public void setNodeValue(String nodeValue) {
            this.m_nodeValue = nodeValue;
        }

        public String getClassName() {
            return this.m_className;
        }

        public void setClassName(String className) {
            this.m_className = className;
        }
    }

    public static class EntryPointDefinitionUpdate {
        private final IType m_entryPointDefinition;
        private final String m_entryPointPackage;
        private final String m_entryPointName;
        private final String m_portTypeName;
        private final String m_portTypePackage;

        public EntryPointDefinitionUpdate(IType entryPointDefinitions, String entryPointPackage, String entryPointName, String portTypeName, String portTypePackage) {
            this.m_entryPointDefinition = entryPointDefinitions;
            this.m_entryPointPackage = entryPointPackage;
            this.m_entryPointName = entryPointName;
            this.m_portTypeName = portTypeName;
            this.m_portTypePackage = portTypePackage;
        }

        public IType getEntryPointDefinition() {
            return this.m_entryPointDefinition;
        }

        public String getEntryPointPackage() {
            return this.m_entryPointPackage;
        }

        public String getEntryPointName() {
            return this.m_entryPointName;
        }

        public String getPortTypeName() {
            return this.m_portTypeName;
        }

        public String getPortTypePackage() {
            return this.m_portTypePackage;
        }
    }

    public static class WebServiceClientUpdate {
        private final IType m_webServiceClient;
        private final String m_package;
        private final String m_portTypeName;
        private final String m_webServiceName;

        public WebServiceClientUpdate(IType webServiceClient, String pck, String portTypeName, String webServiceName) {
            this.m_webServiceClient = webServiceClient;
            this.m_package = pck;
            this.m_portTypeName = portTypeName;
            this.m_webServiceName = webServiceName;
        }

        public IType getWebServiceClient() {
            return this.m_webServiceClient;
        }

        public String getPackage() {
            return this.m_package;
        }

        public String getPortTypeName() {
            return this.m_portTypeName;
        }

        public String getWebServiceName() {
            return this.m_webServiceName;
        }
    }

    public static class WebServiceImplementationUpdate {
        private final IType m_webServiceImpl;
        private final String m_package;
        private final String m_portTypeName;

        public WebServiceImplementationUpdate(IType webServiceImpl, String package1, String portTypeName) {
            this.m_webServiceImpl = webServiceImpl;
            this.m_package = package1;
            this.m_portTypeName = portTypeName;
        }

        public IType getWebServiceImpl() {
            return this.m_webServiceImpl;
        }

        public String getPackage() {
            return this.m_package;
        }

        public String getPortTypeName() {
            return this.m_portTypeName;
        }
    }
}

