/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.query.FileQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.tools.internal.views.common.FileSessionFinder;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.ModelExplorerView;
import org.eclipse.ui.PlatformUI;

public class FileHandledBySessionTester
extends PropertyTester {
    private static final String SESSION_FILE_PROPERTY = "isSessionFile";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (SESSION_FILE_PROPERTY.equals(property)) {
            return this.isSessionFile(receiver);
        }
        boolean result = false;
        if (receiver instanceof IFile) {
            IFile receiverFile = (IFile)receiver;
            result = ModelingProject.hasModelingProjectNature((IProject)receiverFile.getProject()) ? true : new FileQuery(receiverFile.getFileExtension()).isSessionResourceFile() || !FileSessionFinder.getSelectedSessions(Collections.singletonList(receiverFile)).isEmpty();
        }
        return result;
    }

    private boolean isSessionFile(Object element) {
        boolean isSessionResourceFile = false;
        if (!ModelExplorerView.class.getTypeName().equals(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getClass().getTypeName()) && element instanceof IFile) {
            List<Session> relatedSessions = FileSessionFinder.getRelatedSessions(Lists.newArrayList((Object[])new IFile[]{(IFile)element}), false, false);
            isSessionResourceFile = !relatedSessions.isEmpty() ? true : new FileQuery((IFile)element).isSessionResourceFile();
        }
        return isSessionResourceFile;
    }
}

