/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.navigator;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.query.RepresentationDescriptionQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.tools.internal.actions.session.OpenRepresentationsAction;
import org.eclipse.sirius.ui.tools.internal.viewpoint.ViewpointHelper;
import org.eclipse.sirius.ui.tools.internal.views.common.item.RepresentationItemImpl;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.OpenRepresentationListener;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class OpenRepresentationListenerWithViewpointActivation
extends OpenRepresentationListener {
    private Session session;

    public OpenRepresentationListenerWithViewpointActivation(Session theSession) {
        this.session = theSession;
    }

    @Override
    public void doubleClick(DoubleClickEvent event) {
        List selection;
        Iterable<DRepresentationDescriptor> repDescriptorToOpen;
        if (event != null && event.getSelection() instanceof IStructuredSelection && !Iterables.isEmpty(repDescriptorToOpen = this.getRepresentationDescriptorsToOpen(selection = ((IStructuredSelection)event.getSelection()).toList()))) {
            this.activateViewpoints(selection);
            new OpenRepresentationsAction(Sets.newLinkedHashSet(repDescriptorToOpen)).run();
        }
    }

    private void activateViewpoints(List<?> selection) {
        List<RepresentationItemImpl> representationItemList = this.getRepresentationItems(selection);
        HashSet<Viewpoint> viewpointsToActivate = new HashSet<Viewpoint>();
        for (RepresentationItemImpl representationItemImpl : representationItemList) {
            boolean activateViewpoint;
            Viewpoint parentViewpoint = ViewpointHelper.getViewpointInVSM(this.session, new RepresentationDescriptionQuery(representationItemImpl.getDRepresentationDescriptor().getDescription()).getParentViewpoint());
            if (parentViewpoint == null) continue;
            boolean bl = activateViewpoint = !ViewpointHelper.isViewpointEnabledInSession(this.session, parentViewpoint);
            if (!activateViewpoint) continue;
            viewpointsToActivate.add(parentViewpoint);
        }
        if (!viewpointsToActivate.isEmpty()) {
            ViewpointHelper.handleViewpointActivation(this.session, viewpointsToActivate, true, false);
        }
    }

    private List<RepresentationItemImpl> getRepresentationItems(List<?> selection) {
        ArrayList<RepresentationItemImpl> representationItemList = new ArrayList<RepresentationItemImpl>();
        for (Object obj : selection) {
            if (!(obj instanceof RepresentationItemImpl)) continue;
            representationItemList.add((RepresentationItemImpl)obj);
        }
        return representationItemList;
    }
}

