/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.util;

import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.sphinx.emf.validation.ui.util.ExtendedDiagnosticComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ExtendedDiagnosticDialog
extends IconAndMessageDialog {
    private Button detailsButton;
    private String title;
    private ExtendedDiagnosticComposite diagnosticComposite;
    private ExtendedDiagnosticComposite.TextProvider textProvider;
    private int severityMask = 65535;
    private List<Diagnostic> diagnostics;
    private boolean shouldIncludeTopLevelDiagnostic = false;

    public static int open(Shell parent, String dialogTitle, String message, List<Diagnostic> diagnostics) {
        return ExtendedDiagnosticDialog.open(parent, dialogTitle, message, diagnostics, 7);
    }

    public static int openProblem(Shell parent, String dialogTitle, String message, List<Diagnostic> diagnostics) {
        return ExtendedDiagnosticDialog.open(parent, dialogTitle, message, diagnostics, ExtendedDiagnosticComposite.ERROR_WARNING_MASK);
    }

    public static int open(Shell parentShell, String title, String message, List<Diagnostic> diagnostics, int displayMask) {
        ExtendedDiagnosticDialog dialog = new ExtendedDiagnosticDialog(parentShell, title, message, diagnostics, displayMask);
        return dialog.open();
    }

    protected static boolean shouldDisplay(List<Diagnostic> diagnostics, int mask) {
        return false;
    }

    public ExtendedDiagnosticDialog(Shell parentShell, String dialogTitle, String message, List<Diagnostic> diagnostics, int severityMask) {
        super(parentShell);
        this.title = dialogTitle == null ? JFaceResources.getString((String)"Problem_Occurred") : dialogTitle;
        this.message = message == null ? "At least one constraint have not been respected" : message;
        this.diagnostics = diagnostics;
        this.severityMask = severityMask;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void setTextProvider(ExtendedDiagnosticComposite.TextProvider textProvider) {
        this.textProvider = textProvider;
        if (this.diagnosticComposite != null) {
            this.diagnosticComposite.setTextProvider(this.getTextProvider());
        }
    }

    public ExtendedDiagnosticComposite.TextProvider getTextProvider() {
        return this.textProvider;
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createDetailsButton(parent);
    }

    protected void createDetailsButton(Composite parent) {
        if (this.shouldShowDetailsButton()) {
            this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData childData = new GridData(768);
        childData.horizontalSpan = 2;
        composite.setLayoutData((Object)childData);
        composite.setFont(parent.getFont());
        return composite;
    }

    protected void createDialogAndButtonArea(Composite parent) {
        Composite dialogComposite;
        super.createDialogAndButtonArea(parent);
        if (this.dialogArea instanceof Composite && (dialogComposite = (Composite)this.dialogArea).getChildren().length == 0) {
            new Label(dialogComposite, 0);
        }
    }

    protected Image getImage() {
        return this.getErrorImage();
    }

    protected ExtendedDiagnosticComposite createExtendedDiagnosticComposite(Composite parent) {
        ExtendedDiagnosticComposite diagnosticComposite = new ExtendedDiagnosticComposite(parent, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = 200;
        diagnosticComposite.setLayoutData(data);
        if (this.getTextProvider() != null) {
            diagnosticComposite.setTextProvider(this.getTextProvider());
        }
        diagnosticComposite.initialize(null);
        this.populate(diagnosticComposite, this.diagnostics, this.shouldIncludeTopLevelDiagnostic);
        return diagnosticComposite;
    }

    public int open() {
        return super.open();
    }

    private void populate(ExtendedDiagnosticComposite diagnosticComposite, List<Diagnostic> diagnostics, boolean includeDiagnostic) {
        diagnosticComposite.setShowRootDiagnostic(includeDiagnostic);
        diagnosticComposite.setSeverityMask(this.severityMask);
        diagnosticComposite.setDiagnostics(diagnostics);
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        if (this.diagnosticComposite != null) {
            this.diagnosticComposite.dispose();
            this.diagnosticComposite = null;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.diagnosticComposite = this.createExtendedDiagnosticComposite((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, newSize.y));
    }

    public boolean close() {
        this.diagnostics = null;
        this.diagnosticComposite = null;
        return super.close();
    }

    protected boolean shouldShowDetailsButton() {
        return this.diagnostics.size() > 0;
    }
}

